/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.Mutation;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerWriteSchemaTransformProvider_SpannerWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class SpannerWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<SpannerWriteSchemaTransformConfiguration> {
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration> configurationClass() {
        return SpannerWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration configuration) {
        return new SpannerSchemaTransformWrite(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:spanner_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("failures");
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class SpannerWriteSchemaTransformConfiguration
    implements Serializable {
        @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getDatabaseId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getTableId();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_SpannerWriteSchemaTransformProvider_SpannerWriteSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabaseId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration build();
        }
    }

    static class SpannerSchemaTransformWrite
    implements SchemaTransform,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration configuration;

        SpannerSchemaTransformWrite(@UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@NonNull @UnknownKeyFor @Initialized PCollectionRowTuple input) {
                    SpannerWriteResult result = (SpannerWriteResult)((PCollection)input.get("input").apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Row, Mutation>((SerializableFunction & Serializable)row -> MutationUtils.createMutationFromBeamRows(Mutation.newInsertOrUpdateBuilder((String)configuration.getTableId()), Objects.requireNonNull(row))){}))).apply((PTransform)SpannerIO.write().withDatabaseId(configuration.getDatabaseId()).withInstanceId(configuration.getInstanceId()).withFailureMode(SpannerIO.FailureMode.REPORT_FAILURES));
                    Schema failureSchema = Schema.builder().addStringField("operation").addStringField("instanceId").addStringField("databaseId").addStringField("tableId").addStringField("mutationData").build();
                    PCollection failures = ((PCollection)result.getFailedMutations().apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)mtg -> Objects.requireNonNull(mtg).attached().stream().map(mutation -> Row.withSchema((Schema)failureSchema).addValue((Object)mutation.getOperation().toString()).addValue((Object)configuration.getInstanceId()).addValue((Object)configuration.getDatabaseId()).addValue((Object)mutation.getTable()).addValue((Object)Iterators.toString(mutation.getValues().iterator())).build()).collect(Collectors.toList())))).setRowSchema(failureSchema);
                    return PCollectionRowTuple.of((String)"failures", (PCollection)failures);
                }
            };
        }
    }
}

