/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.exslt;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;

public abstract class Random {
    public static SequenceIterator randomSequence(int n, double d) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("numberOfItems supplied to randomSequence() must be positive");
        }
        long l = Double.doubleToLongBits(d);
        return new RandomIterator(n, l);
    }

    public static SequenceIterator randomSequence(int n) throws IllegalArgumentException {
        return Random.randomSequence(n, System.currentTimeMillis());
    }

    public static DoubleValue randomSequence() throws XPathException {
        return (DoubleValue)Random.randomSequence(1).next();
    }

    private static class RandomIterator
    extends AxisIteratorImpl {
        private int count;
        private long seed;
        private java.util.Random generator;

        public RandomIterator(int n, long l) {
            this.count = n;
            this.seed = l;
            this.generator = new java.util.Random(l);
        }

        public Item next() {
            if (this.position++ >= this.count) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = new DoubleValue(this.generator.nextDouble());
            return this.current;
        }

        public SequenceIterator getAnother() {
            return new RandomIterator(this.count, this.seed);
        }
    }
}

