/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.testing;

import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.TransportChannel;
import com.google.common.truth.Truth;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class MockServiceHelperTest {
    @Mock
    private MockGrpcService grpcService;
    @Mock
    private MockGrpcService grpcService2;
    @Mock
    private Server server;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.grpcService.getServiceDefinition()).thenReturn((Object)ServerServiceDefinition.builder((String)"fake-service").build());
        Mockito.when((Object)this.grpcService2.getServiceDefinition()).thenReturn((Object)ServerServiceDefinition.builder((String)"fake-service2").build());
    }

    @Test
    public void testGetService() {
        MockServiceHelper serviceHelper = new MockServiceHelper(this.server, "fake-address", this.grpcService);
        Truth.assertThat((Object)serviceHelper.getService()).isSameInstanceAs((Object)this.grpcService);
        Truth.assertThat((Integer)serviceHelper.getServices().size()).isEqualTo((Object)1);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetServiceInvalid() {
        MockServiceHelper serviceHelper = new MockServiceHelper(this.server, "fake-address2", Arrays.asList(this.grpcService, this.grpcService2));
        serviceHelper.getService();
    }

    @Test
    public void testStart() throws IOException {
        MockServiceHelper serviceHelper = new MockServiceHelper(this.server, "fake-address", this.grpcService);
        serviceHelper.start();
        ((Server)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void testReset() {
        MockServiceHelper serviceHelper = new MockServiceHelper("fake-address", this.grpcService);
        serviceHelper.reset();
        ((MockGrpcService)Mockito.verify((Object)this.grpcService, (VerificationMode)Mockito.times((int)1))).getServiceDefinition();
        ((MockGrpcService)Mockito.verify((Object)this.grpcService, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void testCreateChannelProvider() throws Exception {
        MockServiceHelper serviceHelper = new MockServiceHelper("fake-address", this.grpcService);
        TransportChannel channel = serviceHelper.createChannelProvider().getTransportChannel();
        Assert.assertNotNull((Object)channel);
        Assert.assertFalse((boolean)channel.isTerminated());
        channel.shutdownNow();
    }
}

