/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.internal.io.FileNameSpec;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol$;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.mapred.SparkHadoopMapRedUtil$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001\u0002\u0012$\u00019B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005}!A!\n\u0001B\u0001B\u0003%1\nC\u0003O\u0001\u0011\u0005q\nC\u0005U\u0001\u0001\u0007\t\u0019!C\u0005+\"Ia\f\u0001a\u0001\u0002\u0004%Ia\u0018\u0005\nK\u0002\u0001\r\u0011!Q!\nYCqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004m\u0001\u0001\u0006Ia\u0013\u0005\b[\u0002\u0001\r\u0011\"\u0003o\u0011\u001d9\b\u00011A\u0005\naDaA\u001f\u0001!B\u0013y\u0007b\u0002?\u0001\u0001\u0004%I! \u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000bAq!!\u0003\u0001A\u0003&a\u0010\u0003\u0006\u0002\u000e\u0001A)\u0019!C\t\u0003\u001fAq!a\b\u0001\t#\t\t\u0003C\u0004\u0002.\u0001!\t%a\f\t\u000f\u00055\u0002\u0001\"\u0011\u0002D!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA*\u0001\u0011\u0005\u0013q\f\u0005\b\u0003O\u0002A\u0011CA5\u0011\u001d\ty\u0007\u0001C!\u0003cBq!! \u0001\t\u0003\ny\bC\u0004\u0002(\u0002!\t%!+\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u00111\u0017\u0001\u0005B\u0005U\u0006bBA]\u0001\u0011\u0005\u00131X\u0004\n\u0003\u007f\u001b\u0013\u0011!E\u0001\u0003\u00034\u0001BI\u0012\u0002\u0002#\u0005\u00111\u0019\u0005\u0007\u001dz!\t!a3\t\u0013\u00055g$%A\u0005\u0002\u0005=\u0007\"CAs=\u0005\u0005I\u0011BAt\u0005uA\u0015\rZ8pa6\u000b\u0007OU3ek\u000e,7i\\7nSR\u0004&o\u001c;pG>d'B\u0001\u0013&\u0003\tIwN\u0003\u0002'O\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00184sA\u0011\u0001'M\u0007\u0002G%\u0011!g\t\u0002\u0013\r&dWmQ8n[&$\bK]8u_\u000e|G\u000e\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002;w5\tQ%\u0003\u0002=K\t9Aj\\4hS:<\u0017!\u00026pE&#\u0007CA G\u001d\t\u0001E\t\u0005\u0002Bk5\t!I\u0003\u0002D[\u00051AH]8pizJ!!R\u001b\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bV\nA\u0001]1uQ\u0006IB-\u001f8b[&\u001c\u0007+\u0019:uSRLwN\\(wKJ<(/\u001b;f!\t!D*\u0003\u0002Nk\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0003Q#J\u001b\u0006C\u0001\u0019\u0001\u0011\u0015iD\u00011\u0001?\u0011\u0015IE\u00011\u0001?\u0011\u001dQE\u0001%AA\u0002-\u000b\u0011bY8n[&$H/\u001a:\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u00135\f\u0007O]3ek\u000e,'BA.*\u0003\u0019A\u0017\rZ8pa&\u0011Q\f\u0017\u0002\u0010\u001fV$\b/\u001e;D_6l\u0017\u000e\u001e;fe\u0006i1m\\7nSR$XM]0%KF$\"\u0001Y2\u0011\u0005Q\n\u0017B\u000126\u0005\u0011)f.\u001b;\t\u000f\u00114\u0011\u0011!a\u0001-\u0006\u0019\u0001\u0010J\u0019\u0002\u0015\r|W.\\5ui\u0016\u0014\b\u0005\u000b\u0002\bOB\u0011A\u0007[\u0005\u0003SV\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0019!\f7OV1mS\u0012\u0004\u0016\r\u001e5\u0016\u0003-\u000bQ\u0002[1t-\u0006d\u0017\u000e\u001a)bi\"\u0004\u0013!E1eI\u0016$\u0017IY:QCRDg)\u001b7fgV\tq\u000e\u0005\u0003qkzrT\"A9\u000b\u0005I\u001c\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003iV\n!bY8mY\u0016\u001cG/[8o\u0013\t1\u0018OA\u0002NCB\fQ#\u00193eK\u0012\f%m\u001d)bi\"4\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0002as\"9AmCA\u0001\u0002\u0004y\u0017AE1eI\u0016$\u0017IY:QCRDg)\u001b7fg\u0002B#\u0001D4\u0002\u001dA\f'\u000f^5uS>t\u0007+\u0019;igV\ta\u0010E\u0002q\u007fzJ1!!\u0001r\u0005\r\u0019V\r^\u0001\u0013a\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5t?\u0012*\u0017\u000fF\u0002a\u0003\u000fAq\u0001\u001a\b\u0002\u0002\u0003\u0007a0A\bqCJ$\u0018\u000e^5p]B\u000bG\u000f[:!Q\tyq-\u0001\u0006ti\u0006<\u0017N\\4ESJ,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006[\u0003\t17/\u0003\u0003\u0002\u001c\u0005U!\u0001\u0002)bi\"D#\u0001E4\u0002\u001dM,G/\u001e9D_6l\u0017\u000e\u001e;feR\u0019a+a\t\t\u000f\u0005\u0015\u0012\u00031\u0001\u0002(\u000591m\u001c8uKb$\bcA,\u0002*%\u0019\u00111\u0006-\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\u0010]\u0016<H+Y:l)\u0016l\u0007OR5mKR9a(!\r\u00026\u0005}\u0002bBA\u001a%\u0001\u0007\u0011qE\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000fC\u0004\u00028I\u0001\r!!\u000f\u0002\u0007\u0011L'\u000f\u0005\u00035\u0003wq\u0014bAA\u001fk\t1q\n\u001d;j_:Da!!\u0011\u0013\u0001\u0004q\u0014aA3yiR9a(!\u0012\u0002H\u0005%\u0003bBA\u001a'\u0001\u0007\u0011q\u0005\u0005\b\u0003o\u0019\u0002\u0019AA\u001d\u0011\u001d\tYe\u0005a\u0001\u0003\u001b\nAa\u001d9fGB\u0019\u0001'a\u0014\n\u0007\u0005E3E\u0001\u0007GS2,g*Y7f'B,7-\u0001\foK^$\u0016m]6UK6\u0004h)\u001b7f\u0003\n\u001c\b+\u0019;i)\u001dq\u0014qKA-\u0003;Bq!a\r\u0015\u0001\u0004\t9\u0003\u0003\u0004\u0002\\Q\u0001\rAP\u0001\fC\n\u001cx\u000e\\;uK\u0012K'\u000f\u0003\u0004\u0002BQ\u0001\rA\u0010\u000b\b}\u0005\u0005\u00141MA3\u0011\u001d\t\u0019$\u0006a\u0001\u0003OAa!a\u0017\u0016\u0001\u0004q\u0004bBA&+\u0001\u0007\u0011QJ\u0001\fO\u0016$h)\u001b7f]\u0006lW\rF\u0003?\u0003W\ni\u0007C\u0004\u00024Y\u0001\r!a\n\t\u000f\u0005-c\u00031\u0001\u0002N\u0005A1/\u001a;va*{'\rF\u0002a\u0003gBq!!\u001e\u0018\u0001\u0004\t9(\u0001\u0006k_\n\u001cuN\u001c;fqR\u00042aVA=\u0013\r\tY\b\u0017\u0002\u000b\u0015>\u00147i\u001c8uKb$\u0018!C2p[6LGOS8c)\u0015\u0001\u0017\u0011QAB\u0011\u001d\t)\b\u0007a\u0001\u0003oBq!!\"\u0019\u0001\u0004\t9)A\u0006uCN\\7i\\7nSR\u001c\bCBAE\u0003'\u000bIJ\u0004\u0003\u0002\f\u0006=ebA!\u0002\u000e&\ta'C\u0002\u0002\u0012V\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0006]%aA*fc*\u0019\u0011\u0011S\u001b\u0011\t\u0005m\u0015\u0011\u0015\b\u0004a\u0005u\u0015bAAPG\u0005\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m\u0013\u0011\t\u0019+!*\u0003#Q\u000b7o[\"p[6LG/T3tg\u0006<WMC\u0002\u0002 \u000e\n\u0001\"\u00192peRTuN\u0019\u000b\u0004A\u0006-\u0006bBA;3\u0001\u0007\u0011qO\u0001\ng\u0016$X\u000f\u001d+bg.$2\u0001YAY\u0011\u001d\t\u0019D\u0007a\u0001\u0003O\t!bY8n[&$H+Y:l)\u0011\tI*a.\t\u000f\u0005M2\u00041\u0001\u0002(\u0005I\u0011MY8siR\u000b7o\u001b\u000b\u0004A\u0006u\u0006bBA\u001a9\u0001\u0007\u0011qE\u0001\u001e\u0011\u0006$wn\u001c9NCB\u0014V\rZ;dK\u000e{W.\\5u!J|Go\\2pYB\u0011\u0001GH\n\u0005=\u0005\u00157\u0007E\u00025\u0003\u000fL1!!36\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011Y\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E'fA&\u0002T.\u0012\u0011Q\u001b\t\u0005\u0003/\f\t/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003%)hn\u00195fG.,GMC\u0002\u0002`V\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019/!7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006sK\u0006$'+Z:pYZ,GCAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\fA\u0001\\1oO*\u0011\u00111_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002x\u00065(AB(cU\u0016\u001cG\u000f")
public class HadoopMapReduceCommitProtocol
extends FileCommitProtocol
implements scala.Serializable {
    private transient Path stagingDir;
    private final String jobId;
    private final String path;
    private final boolean dynamicPartitionOverwrite;
    private transient OutputCommitter committer;
    private final boolean hasValidPath;
    private transient Map<String, String> addedAbsPathFiles;
    private transient Set<String> partitionPaths;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$3() {
        return HadoopMapReduceCommitProtocol$.MODULE$.$lessinit$greater$default$3();
    }

    private OutputCommitter committer() {
        return this.committer;
    }

    private void committer_$eq(OutputCommitter x$1) {
        this.committer = x$1;
    }

    private boolean hasValidPath() {
        return this.hasValidPath;
    }

    private Map<String, String> addedAbsPathFiles() {
        return this.addedAbsPathFiles;
    }

    private void addedAbsPathFiles_$eq(Map<String, String> x$1) {
        this.addedAbsPathFiles = x$1;
    }

    private Set<String> partitionPaths() {
        return this.partitionPaths;
    }

    private void partitionPaths_$eq(Set<String> x$1) {
        this.partitionPaths = x$1;
    }

    private Path stagingDir$lzycompute() {
        HadoopMapReduceCommitProtocol hadoopMapReduceCommitProtocol = this;
        synchronized (hadoopMapReduceCommitProtocol) {
            if (!this.bitmap$trans$0) {
                this.stagingDir = FileCommitProtocol$.MODULE$.getStagingDir(this.path, this.jobId);
                this.bitmap$trans$0 = true;
            }
        }
        return this.stagingDir;
    }

    public Path stagingDir() {
        if (!this.bitmap$trans$0) {
            return this.stagingDir$lzycompute();
        }
        return this.stagingDir;
    }

    public OutputCommitter setupCommitter(TaskAttemptContext context) {
        OutputFormat format;
        block0: {
            format = (OutputFormat)context.getOutputFormatClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            OutputFormat outputFormat = format;
            if (!(outputFormat instanceof Configurable)) break block0;
            OutputFormat outputFormat2 = outputFormat;
            ((Configurable)outputFormat2).setConf(context.getConfiguration());
        }
        return format.getOutputCommitter(context);
    }

    @Override
    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, String ext) {
        return this.newTaskTempFile(taskContext, dir, new FileNameSpec("", ext));
    }

    @Override
    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, FileNameSpec spec) {
        Path path;
        String filename = this.getFilename(taskContext, spec);
        OutputCommitter outputCommitter = this.committer();
        if (outputCommitter instanceof FileOutputCommitter) {
            BoxedUnit boxedUnit;
            FileOutputCommitter fileOutputCommitter = (FileOutputCommitter)outputCommitter;
            if (this.dynamicPartitionOverwrite) {
                Predef$.MODULE$.assert(dir.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "The dataset to be written must be partitioned when dynamicPartitionOverwrite is true.");
                boxedUnit = this.partitionPaths().$plus$eq(dir.get());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            path = new Path((String)Option$.MODULE$.apply((Object)fileOutputCommitter.getWorkPath()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.path));
        } else {
            path = new Path(this.path);
        }
        Path stagingDir = path;
        return (String)dir.map((Function1 & Serializable & scala.Serializable)d -> new Path(new Path(stagingDir, d), filename).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Path(stagingDir, filename).toString());
    }

    @Override
    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, String ext) {
        return this.newTaskTempFileAbsPath(taskContext, absoluteDir, new FileNameSpec("", ext));
    }

    @Override
    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, FileNameSpec spec) {
        String filename = this.getFilename(taskContext, spec);
        String absOutputPath = new Path(absoluteDir, filename).toString();
        String tmpOutputPath = new Path(this.stagingDir(), new StringBuilder(1).append(UUID.randomUUID().toString()).append("-").append(filename).toString()).toString();
        this.addedAbsPathFiles().update((Object)tmpOutputPath, (Object)absOutputPath);
        return tmpOutputPath;
    }

    public String getFilename(TaskAttemptContext taskContext, FileNameSpec spec) {
        int split = taskContext.getTaskAttemptID().getTaskID().getId();
        String arg$macro$1 = spec.prefix();
        int arg$macro$2 = split;
        String arg$macro$3 = this.jobId;
        String arg$macro$4 = spec.suffix();
        return new StringOps("%spart-%05d-%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToInteger((int)arg$macro$2), arg$macro$3, arg$macro$4}));
    }

    @Override
    public void setupJob(JobContext jobContext) {
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(), 0);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, 0);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, 0);
        jobContext.getConfiguration().set("mapreduce.job.id", jobId.toString());
        jobContext.getConfiguration().set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        jobContext.getConfiguration().set("mapreduce.task.attempt.id", taskAttemptId.toString());
        jobContext.getConfiguration().setBoolean("mapreduce.task.ismap", true);
        jobContext.getConfiguration().setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(jobContext.getConfiguration(), taskAttemptId);
        this.committer_$eq(this.setupCommitter((TaskAttemptContext)taskAttemptContext));
        this.committer().setupJob(jobContext);
    }

    @Override
    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        this.committer().commitJob(jobContext);
        if (this.hasValidPath()) {
            Tuple2 tuple2 = ((GenericTraversableTemplate)taskCommits.map((Function1 & Serializable & scala.Serializable)x$2 -> (Tuple2)x$2.obj(), Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq allAbsPathFiles = (Seq)tuple2._1();
            Seq allPartitionPaths = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)allAbsPathFiles, (Object)allPartitionPaths);
            Seq allAbsPathFiles2 = (Seq)tuple22._1();
            Seq allPartitionPaths2 = (Seq)tuple22._2();
            FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
            scala.collection.immutable.Map filesToMove = (scala.collection.immutable.Map)allAbsPathFiles2.foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.$plus$plus((GenTraversableOnce)x$5));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Committing files staged for absolute locations ").append(filesToMove).toString());
            scala.collection.immutable.Set absParentPaths = ((TraversableOnce)filesToMove.values().map((Function1 & Serializable & scala.Serializable)x$6 -> new Path(x$6).getParent(), Iterable$.MODULE$.canBuildFrom())).toSet();
            if (this.dynamicPartitionOverwrite) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Clean up absolute partition directories for overwriting: ").append(absParentPaths).toString());
                absParentPaths.foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)fs.delete(x$7, true)));
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Create absolute parent directories: ").append(absParentPaths).toString());
            absParentPaths.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(x$1)));
            filesToMove.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$commitJob$9(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                HadoopMapReduceCommitProtocol.$anonfun$commitJob$10(fs, x$8);
                return BoxedUnit.UNIT;
            });
            if (this.dynamicPartitionOverwrite) {
                scala.collection.immutable.Set partitionPaths = (scala.collection.immutable.Set)allPartitionPaths2.foldLeft((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> (scala.collection.immutable.Set)x$9.$plus$plus((GenTraversableOnce)x$10));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Clean up default partition directories for overwriting: ").append(partitionPaths).toString());
                partitionPaths.foreach((Function1 & Serializable & scala.Serializable)part -> {
                    HadoopMapReduceCommitProtocol.$anonfun$commitJob$13(this, fs, part);
                    return BoxedUnit.UNIT;
                });
            }
            fs.delete(this.stagingDir(), true);
            return;
        }
    }

    @Override
    public void abortJob(JobContext jobContext) {
        try {
            this.committer().abortJob(jobContext, JobStatus.State.FAILED);
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(jobContext.getJobID()).toString(), e);
        }
        try {
            if (this.hasValidPath()) {
                FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
                fs.delete(this.stagingDir(), true);
            }
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(jobContext.getJobID()).toString(), e);
        }
    }

    @Override
    public void setupTask(TaskAttemptContext taskContext) {
        this.committer_$eq(this.setupCommitter(taskContext));
        this.committer().setupTask(taskContext);
        this.addedAbsPathFiles_$eq((Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.partitionPaths_$eq((Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    @Override
    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        TaskAttemptID attemptId = taskContext.getTaskAttemptID();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Commit task ").append(attemptId).toString());
        SparkHadoopMapRedUtil$.MODULE$.commitTask(this.committer(), taskContext, attemptId.getJobID().getId(), attemptId.getTaskID().getId());
        return new FileCommitProtocol.TaskCommitMessage(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.addedAbsPathFiles().toMap(Predef$.MODULE$.$conforms())), (Object)this.partitionPaths().toSet()));
    }

    @Override
    public void abortTask(TaskAttemptContext taskContext) {
        try {
            this.committer().abortTask(taskContext);
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(taskContext.getTaskAttemptID()).toString(), e);
        }
        try {
            this.addedAbsPathFiles().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$3(taskContext, x$11)));
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(taskContext.getTaskAttemptID()).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$commitJob$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$commitJob$10(FileSystem fs$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            String dst;
            String src = (String)tuple2._1();
            if (!fs$1.rename(new Path(src), new Path(dst = (String)tuple2._2()))) {
                throw new IOException(new StringBuilder(73).append("Failed to rename ").append(src).append(" to ").append(dst).append(" when committing files staged for ").append("absolute locations").toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$commitJob$13(HadoopMapReduceCommitProtocol $this, FileSystem fs$1, String part) {
        Path finalPartPath = new Path($this.path, part);
        Object object = !fs$1.delete(finalPartPath, true) && !fs$1.exists(finalPartPath.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs$1.mkdirs(finalPartPath.getParent())) : BoxedUnit.UNIT;
        Path stagingPartPath = new Path($this.stagingDir(), part);
        if (!fs$1.rename(stagingPartPath, finalPartPath)) {
            throw new IOException(new StringBuilder(85).append("Failed to rename ").append(stagingPartPath).append(" to ").append(finalPartPath).append(" when ").append("committing files staged for overwriting dynamic partitions").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$3(TaskAttemptContext taskContext$1, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 != null) {
            String src = (String)tuple2._1();
            Path tmp = new Path(src);
            return tmp.getFileSystem(taskContext$1.getConfiguration()).delete(tmp, false);
        }
        throw new MatchError((Object)tuple2);
    }

    public HadoopMapReduceCommitProtocol(String jobId, String path, boolean dynamicPartitionOverwrite) {
        this.jobId = jobId;
        this.path = path;
        this.dynamicPartitionOverwrite = dynamicPartitionOverwrite;
        this.hasValidPath = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Path($this.path)).isSuccess();
        this.addedAbsPathFiles = null;
        this.partitionPaths = null;
    }
}

