/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;

public class NSString
extends NSObject
implements Comparable<Object> {
    private static CharsetEncoder asciiEncoder;
    private static CharsetEncoder utf16beEncoder;
    private static CharsetEncoder utf8Encoder;
    private String content;

    public NSString(byte[] bytes, String encoding) throws UnsupportedEncodingException {
        this(bytes, 0, bytes.length, encoding);
    }

    public NSString(byte[] bytes, int startIndex, int endIndex, String encoding) throws UnsupportedEncodingException {
        this.content = new String(bytes, startIndex, endIndex - startIndex, encoding);
    }

    public NSString(String string) {
        this.content = string;
    }

    public int intValue() {
        double d = this.doubleValue();
        if (d > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)d;
    }

    public float floatValue() {
        double d = this.doubleValue();
        if (d > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        if (d < -3.4028234663852886E38) {
            return -3.4028235E38f;
        }
        return (float)d;
    }

    public double doubleValue() {
        Scanner s = new Scanner(this.content.trim()).useLocale(Locale.ROOT).useDelimiter("[^\\d.+-]+");
        if (s.hasNextDouble()) {
            return s.nextDouble();
        }
        return 0.0;
    }

    public boolean boolValue() {
        Scanner s = new Scanner(this.content.trim()).useLocale(Locale.ROOT);
        return s.hasNext("([+-]?0*)?[YyTt1-9].*");
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String c) {
        this.content = c;
    }

    public void append(NSString s) {
        this.append(s.getContent());
    }

    public void append(String s) {
        this.content = this.content + s;
    }

    public void prepend(String s) {
        this.content = s + this.content;
    }

    public void prepend(NSString s) {
        this.prepend(s.getContent());
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.content.equals(((NSString)obj).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public String toString() {
        return this.content;
    }

    @Override
    public NSString clone() {
        return new NSString(this.content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<string>");
        Class<NSString> clazz = NSString.class;
        synchronized (NSString.class) {
            if (utf8Encoder == null) {
                utf8Encoder = StandardCharsets.UTF_8.newEncoder();
            } else {
                utf8Encoder.reset();
            }
            try {
                ByteBuffer byteBuf = utf8Encoder.encode(CharBuffer.wrap(this.content));
                byte[] bytes = new byte[byteBuf.remaining()];
                byteBuf.get(bytes);
                this.content = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not encode the NSString into UTF-8: " + ex.getMessage());
            }
            String cleanedContent = NSString.escapeStringForXml(this.content);
            if (cleanedContent.contains("&") || cleanedContent.contains("<") || cleanedContent.contains(">")) {
                xml.append("<![CDATA[");
                xml.append(cleanedContent.replaceAll("]]>", "]]]]><![CDATA[>"));
                xml.append("]]>");
            } else {
                xml.append(cleanedContent);
            }
            xml.append("</string>");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBinary(BinaryPropertyListWriter out) throws IOException {
        CharBuffer charBuf = CharBuffer.wrap(this.content);
        Class<NSString> clazz = NSString.class;
        synchronized (NSString.class) {
            ByteBuffer byteBuf;
            int kind;
            if (asciiEncoder == null) {
                asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            } else {
                asciiEncoder.reset();
            }
            if (asciiEncoder.canEncode((CharSequence)charBuf)) {
                kind = 5;
                byteBuf = asciiEncoder.encode(charBuf);
            } else {
                if (utf16beEncoder == null) {
                    utf16beEncoder = StandardCharsets.UTF_16BE.newEncoder();
                } else {
                    utf16beEncoder.reset();
                }
                kind = 6;
                byteBuf = utf16beEncoder.encode(charBuf);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            byte[] bytes = new byte[byteBuf.remaining()];
            byteBuf.get(bytes);
            out.writeIntHeader(kind, this.content.length());
            out.write(bytes);
            return;
        }
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("\"");
        ascii.append(NSString.escapeStringForASCII(this.content));
        ascii.append("\"");
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("\"");
        ascii.append(NSString.escapeStringForASCII(this.content));
        ascii.append("\"");
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof NSString) {
            return this.getContent().compareTo(((NSString)o).getContent());
        }
        if (o instanceof String) {
            return this.getContent().compareTo((String)o);
        }
        return -1;
    }

    static String escapeStringForASCII(String s) {
        StringBuilder out = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c > '\u007f') {
                out.append("\\U");
                String hex = Integer.toHexString(c);
                while (hex.length() < 4) {
                    hex = "0" + hex;
                }
                out.append(hex);
                continue;
            }
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c == '\b') {
                out.append("\\b");
                continue;
            }
            if (c == '\n') {
                out.append("\\n");
                continue;
            }
            if (c == '\r') {
                out.append("\\r");
                continue;
            }
            if (c == '\t') {
                out.append("\\t");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    static String escapeStringForXml(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int codePoint = s.codePointAt(i);
            if (codePoint > 65535) {
                ++i;
            }
            if (!(codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533) && (codePoint < 65536 || codePoint > 0x10FFFF)) continue;
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }
}

