/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.duckdb.DuckDBAppender;
import org.duckdb.DuckDBDatabase;
import org.duckdb.DuckDBDatabaseMetaData;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBPreparedStatement;

public class DuckDBConnection
implements Connection {
    protected ByteBuffer conn_ref = null;
    protected DuckDBDatabase db;
    protected boolean autoCommit = true;
    protected boolean transactionRunning = false;

    public DuckDBConnection(DuckDBDatabase duckDBDatabase) throws SQLException {
        if (duckDBDatabase.db_ref == null) {
            throw new SQLException("Database was shutdown");
        }
        this.conn_ref = DuckDBNative.duckdb_jdbc_connect(duckDBDatabase.db_ref);
        DuckDBNative.duckdb_jdbc_set_auto_commit(this.conn_ref, true);
        this.db = duckDBDatabase;
        duckDBDatabase.incrementConnections();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        if (n2 == 1007 && n == 1003) {
            return new DuckDBPreparedStatement(this);
        }
        throw new SQLFeatureNotSupportedException("createStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        if (n2 == 1007 && n == 1003) {
            return new DuckDBPreparedStatement(this, string);
        }
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Connection duplicate() throws SQLException {
        if (this.db == null) {
            throw new SQLException("Connection was closed");
        }
        if (this.db.db_ref == null) {
            throw new SQLException("Database was shutdown");
        }
        return new DuckDBConnection(this.db);
    }

    public DuckDBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public void commit() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("COMMIT");
        this.transactionRunning = false;
        statement.close();
    }

    @Override
    public void rollback() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("ROLLBACK");
        this.transactionRunning = false;
        statement.close();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.conn_ref != null) {
            DuckDBNative.duckdb_jdbc_disconnect(this.conn_ref);
            this.conn_ref = null;
            this.db.maybeShutdown();
        }
        this.db = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn_ref == null;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42");
        if (!resultSet.next() || resultSet.getInt(1) != 42) {
            resultSet.close();
            statement.close();
            return false;
        }
        resultSet.close();
        statement.close();
        return true;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (n > 4) {
            throw new SQLFeatureNotSupportedException("setTransactionIsolation");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 4;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (bl != this.db.read_only) {
            throw new SQLFeatureNotSupportedException("Can't change read-only status on connection level.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.db.read_only;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        if (this.autoCommit != bl) {
            this.autoCommit = bl;
            if (this.transactionRunning && bl) {
                this.commit();
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        return this.autoCommit;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, 0);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DuckDBDatabaseMetaData(this);
    }

    @Override
    public void setCatalog(String string) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return DuckDBNative.duckdb_jdbc_get_catalog(this.conn_ref);
    }

    @Override
    public void setSchema(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSchema");
    }

    @Override
    public String getSchema() throws SQLException {
        return DuckDBNative.duckdb_jdbc_get_schema(this.conn_ref);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("abort");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createBlob");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException("isWrapperFor");
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("nativeSQL");
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 0);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, 0);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTypeMap");
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("getHoldability");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint");
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML");
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClientInfo");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException("getClientInfo");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNetworkTimeout");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("getNetworkTimeout");
    }

    public DuckDBAppender createAppender(String string, String string2) throws SQLException {
        return new DuckDBAppender(this, string, string2);
    }

    private static long getArrowStreamAddress(Object object) {
        try {
            Class<?> clazz = Class.forName("org.apache.arrow.c.ArrowArrayStream");
            if (!clazz.isInstance(object)) {
                throw new RuntimeException("Need to pass an ArrowArrayStream");
            }
            return (Long)clazz.getMethod("memoryAddress", new Class[0]).invoke(object, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void registerArrowStream(String string, Object object) {
        long l = DuckDBConnection.getArrowStreamAddress(object);
        DuckDBNative.duckdb_jdbc_arrow_register(this.conn_ref, l, string.getBytes(StandardCharsets.UTF_8));
    }
}

