/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import com.microsoft.azure.storage.blob.BlobInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PageBlobInputStream
extends InputStream {
    private BlobInputStream inputStream;
    private long fileSize;
    private long totalRead = 0L;

    public PageBlobInputStream(BlobInputStream inputStream, long fileSize) {
        this.inputStream = inputStream;
        this.fileSize = fileSize;
    }

    @Override
    public int read() throws IOException {
        int c = this.inputStream.read();
        ++this.totalRead;
        if (this.totalRead > this.fileSize) {
            return -1;
        }
        return c;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int readSize = this.inputStream.read(bytes);
        if (readSize > 0) {
            this.totalRead += (long)readSize;
        }
        return readSize;
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        int readSize = this.inputStream.read(bytes, i, i1);
        if (readSize > 0 && this.totalRead + (long)readSize > this.fileSize) {
            int actuallyRead = (int)(this.fileSize - this.totalRead);
            this.totalRead = this.fileSize;
            return actuallyRead;
        }
        return readSize;
    }

    @Override
    public long skip(long l) throws IOException {
        long skippedLength = this.inputStream.skip(l);
        if (skippedLength > 0L) {
            this.totalRead += skippedLength;
            if (this.totalRead + skippedLength > this.fileSize) {
                int actuallyRead = (int)(this.fileSize - this.totalRead);
                this.totalRead = this.fileSize;
                return actuallyRead;
            }
        }
        return skippedLength;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.fileSize - this.totalRead);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int i) {
        this.inputStream.mark(i);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

