/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.WindowSupplier;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

final class StaticWindows
extends NonMergingWindowFn<Object, BoundedWindow> {
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow>> windows;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> coder;
    private final @UnknownKeyFor @NonNull @Initialized boolean onlyExisting;

    private StaticWindows(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow>> windows, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> coder, @UnknownKeyFor @NonNull @Initialized boolean onlyExisting) {
        this.windows = windows;
        this.coder = coder;
        this.onlyExisting = onlyExisting;
    }

    public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StaticWindows of(@UnknownKeyFor @NonNull @Initialized Coder<W> coder, @UnknownKeyFor @NonNull @Initialized Iterable<W> windows) {
        Preconditions.checkArgument((!Iterables.isEmpty(windows) ? 1 : 0) != 0, (Object)"Input windows to StaticWindows may not be empty");
        StaticWindows windowFn = new StaticWindows(WindowSupplier.of(coder, windows), coder, false);
        return windowFn;
    }

    public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StaticWindows of(@UnknownKeyFor @NonNull @Initialized Coder<W> coder, W window) {
        return StaticWindows.of(coder, Collections.singleton(window));
    }

    public @UnknownKeyFor @NonNull @Initialized StaticWindows intoOnlyExisting() {
        return new StaticWindows(this.windows, this.coder, true);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
        return (Collection)this.windows.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> assignWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.onlyExisting) {
            Preconditions.checkArgument((boolean)((Collection)this.windows.get()).contains(c.window()), (Object)"Tried to assign windows to an element that is not already windowed into a provided window when onlyExisting is set to true");
            return Collections.singleton(c.window());
        }
        return this.getWindows();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
        if (!(other instanceof StaticWindows)) {
            return false;
        }
        StaticWindows that = (StaticWindows)other;
        return Objects.equals(this.windows.get(), that.windows.get());
    }

    @Override
    public void verifyCompatibility(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("Only %s objects with the same window supplier are compatible.", StaticWindows.class.getSimpleName()));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder() {
        return this.coder;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @NonNull @Initialized BoundedWindow> getDefaultWindowMappingFn() {
        return new WindowMappingFn<BoundedWindow>(Duration.millis((long)Long.MAX_VALUE)){

            @Override
            public @UnknownKeyFor @NonNull @Initialized BoundedWindow getSideInputWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow mainWindow) {
                Preconditions.checkArgument((boolean)((Collection)StaticWindows.this.windows.get()).contains(mainWindow), (String)"%s only supports side input windows for main input windows that it contains", (Object)StaticWindows.class.getSimpleName());
                return mainWindow;
            }
        };
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean assignsToOneWindow() {
        return true;
    }
}

