/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapElements<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
    private final transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<InputT> inputType;
    private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType;
    private final @Nullable @UnknownKeyFor @Initialized Object fn;

    private MapElements(@Nullable @UnknownKeyFor @Initialized Object fn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<InputT> inputType, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        this.fn = fn;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized MapElements<InputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized InferableFunction<InputT, OutputT> fn) {
        return new MapElements<InputT, OutputT>(fn, fn.getInputTypeDescriptor(), fn.getOutputTypeDescriptor());
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized MapElements<InputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized SimpleFunction<InputT, OutputT> fn) {
        return MapElements.via(fn);
    }

    public static <OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MapElements<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> into(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        return new MapElements(null, null, outputType);
    }

    public <NewInputT> @UnknownKeyFor @NonNull @Initialized MapElements<NewInputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized ProcessFunction<NewInputT, OutputT> fn) {
        return new MapElements<NewInputT, OutputT>(fn, TypeDescriptors.inputOf(fn), this.outputType);
    }

    public <NewInputT> @UnknownKeyFor @NonNull @Initialized MapElements<NewInputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized SerializableFunction<NewInputT, OutputT> fn) {
        return this.via((ProcessFunction<NewInputT, OutputT>)fn);
    }

    public <NewInputT> @UnknownKeyFor @NonNull @Initialized MapElements<NewInputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<NewInputT, OutputT>> fn) {
        return new MapElements<NewInputT, OutputT>(fn, TypeDescriptors.inputOf(fn.getClosure()), this.outputType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InputT> input) {
        Preconditions.checkNotNull((Object)this.fn, (Object)"Must specify a function on MapElements using .via()");
        if (this.fn instanceof Contextful) {
            return (PCollection)input.apply("Map", ParDo.of(new MapDoFn(){

                @DoFn.ProcessElement
                public void processElement(@UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    c.output(((Contextful.Fn)((Contextful)MapElements.this.fn).getClosure()).apply(c.element(), Contextful.Fn.Context.wrapProcessContext(c)));
                }
            }).withSideInputs(((Contextful)this.fn).getRequirements().getSideInputs()));
        }
        if (this.fn instanceof ProcessFunction) {
            return (PCollection)input.apply("Map", ParDo.of(new MapDoFn(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element InputT element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    receiver.output(((ProcessFunction)MapElements.this.fn).apply(element));
                }
            }));
        }
        throw new IllegalArgumentException(String.format("Unknown type of fn class %s", this.fn.getClass()));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        Object fnForDisplayData = this.fn instanceof Contextful ? ((Contextful)this.fn).getClosure() : this.fn;
        builder.add(DisplayData.item("class", fnForDisplayData.getClass()));
        if (fnForDisplayData instanceof HasDisplayData) {
            builder.include("fn", (HasDisplayData)fnForDisplayData);
        }
    }

    public <NewFailureT> @UnknownKeyFor @NonNull @Initialized MapWithFailures<InputT, OutputT, NewFailureT> exceptionsInto(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new MapWithFailures<InputT, OutputT, NewFailureT>(this.fn, this.inputType, this.outputType, null, failureTypeDescriptor);
    }

    public <FailureT> @UnknownKeyFor @NonNull @Initialized MapWithFailures<InputT, OutputT, FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized InferableFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new MapWithFailures<InputT, OutputT, FailureT>(this.fn, this.inputType, this.outputType, exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    public static class MapWithFailures<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor FailureT>
    extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
        private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputType;
        private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType;
        private final transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<FailureT> failureType;
        private final @UnknownKeyFor @NonNull @Initialized Object fn;
        private final @Nullable @UnknownKeyFor @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;

        MapWithFailures(@UnknownKeyFor @NonNull @Initialized Object fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputType, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType, @Nullable @UnknownKeyFor @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<FailureT> failureType) {
            this.fn = fn;
            this.inputType = inputType;
            this.outputType = outputType;
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public @UnknownKeyFor @NonNull @Initialized MapWithFailures<InputT, OutputT, FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
            return new MapWithFailures<InputT, OutputT, FailureT>(this.fn, this.inputType, this.outputType, exceptionHandler, this.failureType);
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized WithFailures.Result<@UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, FailureT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            PCollectionTuple tuple;
            MapWithFailuresDoFn doFn;
            Preconditions.checkArgument((this.exceptionHandler != null ? 1 : 0) != 0, (Object)".exceptionsVia() is required");
            if (this.fn instanceof Contextful) {
                doFn = new MapWithFailuresDoFn(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element InputT element, @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        boolean exceptionWasThrown = false;
                        Object result = null;
                        try {
                            result = ((Contextful.Fn)((Contextful)fn).getClosure()).apply(element, Contextful.Fn.Context.wrapProcessContext(c));
                        }
                        catch (Exception e) {
                            exceptionWasThrown = true;
                            WithFailures.ExceptionElement exceptionElement = WithFailures.ExceptionElement.of(element, e);
                            c.output(this.failureTag, exceptionHandler.apply(exceptionElement));
                        }
                        if (!exceptionWasThrown) {
                            c.output(result);
                        }
                    }
                };
                tuple = (PCollectionTuple)input.apply(MapWithFailures.class.getSimpleName(), ParDo.of(doFn).withOutputTags(doFn.outputTag, TupleTagList.of(doFn.failureTag)).withSideInputs(((Contextful)this.fn).getRequirements().getSideInputs()));
            } else if (this.fn instanceof ProcessFunction) {
                final ProcessFunction closure = (ProcessFunction)this.fn;
                doFn = new MapWithFailuresDoFn(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element InputT element, @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        Object result;
                        boolean exceptionWasThrown = false;
                        try {
                            result = closure.apply(element);
                        }
                        catch (Exception e) {
                            result = null;
                            exceptionWasThrown = true;
                            WithFailures.ExceptionElement exceptionElement = WithFailures.ExceptionElement.of(element, e);
                            c.output(this.failureTag, exceptionHandler.apply(exceptionElement));
                        }
                        if (!exceptionWasThrown) {
                            c.output(result);
                        }
                    }
                };
                tuple = (PCollectionTuple)input.apply(MapWithFailures.class.getSimpleName(), ParDo.of(doFn).withOutputTags(doFn.outputTag, TupleTagList.of(doFn.failureTag)));
            } else {
                throw new IllegalArgumentException(String.format("Unknown type of fn class %s", this.fn.getClass()));
            }
            return WithFailures.Result.of(tuple, doFn.outputTag, doFn.failureTag);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Object fnForDisplayData = this.fn instanceof Contextful ? ((Contextful)this.fn).getClosure() : this.fn;
            builder.add(DisplayData.item("class", fnForDisplayData.getClass()));
            if (fnForDisplayData instanceof HasDisplayData) {
                builder.include("fn", (HasDisplayData)fnForDisplayData);
            }
            builder.add(DisplayData.item("exceptionHandler.class", this.exceptionHandler.getClass()));
            if (this.exceptionHandler instanceof HasDisplayData) {
                builder.include("exceptionHandler", (HasDisplayData)((Object)this.exceptionHandler));
            }
        }

        private abstract class MapWithFailuresDoFn
        extends DoFn<InputT, OutputT> {
            final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag = new TupleTag<OutputT>(){};
            final @UnknownKeyFor @NonNull @Initialized TupleTag<FailureT> failureTag = new FailureTag();

            private MapWithFailuresDoFn() {
            }

            @Override
            public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                builder.delegate(MapWithFailures.this);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> getInputTypeDescriptor() {
                return MapWithFailures.this.inputType;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
                Preconditions.checkState((MapWithFailures.this.outputType != null ? 1 : 0) != 0, (String)"%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)MapWithFailures.class.getSimpleName());
                return MapWithFailures.this.outputType;
            }
        }

        private class FailureTag
        extends TupleTag<FailureT> {
            private FailureTag() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<FailureT> getTypeDescriptor() {
                return MapWithFailures.this.failureType;
            }
        }
    }

    private abstract class MapDoFn
    extends DoFn<InputT, OutputT> {
        private MapDoFn() {
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.delegate(MapElements.this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> getInputTypeDescriptor() {
            return MapElements.this.inputType;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            Preconditions.checkState((MapElements.this.outputType != null ? 1 : 0) != 0, (String)"%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)MapElements.class.getSimpleName());
            return MapElements.this.outputType;
        }
    }
}

