/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.telnet;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.SocketUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="TELNET", name="i18n::ActionTelnet.Name", description="i18n::ActionTelnet.Description", image="Telnet.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionTelnet.keyword"}, documentationUrl="/workflow/actions/telnet.html")
public class ActionTelnet
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionTelnet.class;
    private String hostname = null;
    private String port = String.valueOf(23);
    private String timeout = String.valueOf(3000);
    public static final int DEFAULT_TIME_OUT = 3000;
    public static final int DEFAULT_PORT = 23;

    public ActionTelnet(String n) {
        super(n, "");
    }

    public ActionTelnet() {
        this("");
    }

    public Object clone() {
        ActionTelnet je = (ActionTelnet)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(100);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XmlHandler.addTagValue((String)"timeout", (String)this.timeout));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.hostname = XmlHandler.getTagValue((Node)entrynode, (String)"hostname");
            this.port = XmlHandler.getTagValue((Node)entrynode, (String)"port");
            this.timeout = XmlHandler.getTagValue((Node)entrynode, (String)"timeout");
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'Telnet' from XML node", (Throwable)xe);
        }
    }

    public String getPort() {
        return this.port;
    }

    public String getRealPort() {
        return this.resolve(this.getPort());
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRealHostname() {
        return this.resolve(this.getHostname());
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public String getRealTimeOut() {
        return this.resolve(this.getTimeOut());
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String hostname = this.getRealHostname();
        int port = Const.toInt((String)this.getRealPort(), (int)23);
        int timeoutInt = Const.toInt((String)this.getRealTimeOut(), (int)-1);
        if (Utils.isEmpty((CharSequence)hostname)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionTelnet.SpecifyHost.Label", (String[])new String[0]));
            return result;
        }
        try {
            SocketUtil.connectToHost((String)hostname, (int)port, (int)timeoutInt);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionTelnet.OK.Label", (Object[])new Object[]{hostname, port}));
            }
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionTelnet.NOK.Label", (String[])new String[]{hostname, String.valueOf(port)}));
            this.logError(BaseMessages.getString(PKG, (String)"ActionTelnet.Error.Label", (String[])new String[0]) + ex.getMessage());
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.hostname)) {
            String realServername = this.resolve(this.hostname);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "hostname", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

