/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpAuthUtils {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String BASIC = "Basic";
    public static final String NEGOTIATE = "Negotiate";
    private static final Logger LOG = LoggerFactory.getLogger(HttpAuthUtils.class);
    private static final String COOKIE_ATTR_SEPARATOR = "&";
    private static final String COOKIE_CLIENT_USER_NAME = "cu";
    private static final String COOKIE_CLIENT_RAND_NUMBER = "rn";
    private static final String COOKIE_KEY_VALUE_SEPARATOR = "=";
    private static final Set<String> COOKIE_ATTRIBUTES = new HashSet<String>(Arrays.asList("cu", "rn"));

    public static String getKerberosServiceTicket(String principal, String host, String serverHttpUrl, Subject loggedInSubject) throws Exception {
        String serverPrincipal = HadoopThriftAuthBridge.getBridge().getServerPrincipal(principal, host);
        if (loggedInSubject != null) {
            return Subject.doAs(loggedInSubject, new HttpKerberosClientAction(serverPrincipal, serverHttpUrl));
        }
        UserGroupInformation clientUGI = HadoopThriftAuthBridge.getBridge().getCurrentUGIWithConf("kerberos");
        return (String)clientUGI.doAs((PrivilegedExceptionAction)new HttpKerberosClientAction(serverPrincipal, serverHttpUrl));
    }

    public static String createCookieToken(String clientUserName) {
        StringBuilder sb = new StringBuilder();
        sb.append(COOKIE_CLIENT_USER_NAME).append(COOKIE_KEY_VALUE_SEPARATOR).append(clientUserName).append(COOKIE_ATTR_SEPARATOR);
        sb.append(COOKIE_CLIENT_RAND_NUMBER).append(COOKIE_KEY_VALUE_SEPARATOR).append(new SecureRandom().nextLong());
        return sb.toString();
    }

    public static String getUserNameFromCookieToken(String tokenStr) {
        Map<String, String> map = HttpAuthUtils.splitCookieToken(tokenStr);
        if (!map.keySet().equals(COOKIE_ATTRIBUTES)) {
            LOG.error("Invalid token with missing attributes " + tokenStr);
            return null;
        }
        return map.get(COOKIE_CLIENT_USER_NAME);
    }

    private static Map<String, String> splitCookieToken(String tokenStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(tokenStr, COOKIE_ATTR_SEPARATOR);
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            int separator = part.indexOf(COOKIE_KEY_VALUE_SEPARATOR);
            if (separator == -1) {
                LOG.error("Invalid token string " + tokenStr);
                return null;
            }
            String key = part.substring(0, separator);
            String value = part.substring(separator + 1);
            map.put(key, value);
        }
        return map;
    }

    private HttpAuthUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static class HttpKerberosClientAction
    implements PrivilegedExceptionAction<String> {
        public static final String HTTP_RESPONSE = "HTTP_RESPONSE";
        public static final String SERVER_HTTP_URL = "SERVER_HTTP_URL";
        private final String serverPrincipal;
        private final String serverHttpUrl;
        private final Base64 base64codec;
        private final HttpContext httpContext;

        public HttpKerberosClientAction(String serverPrincipal, String serverHttpUrl) {
            this.serverPrincipal = serverPrincipal;
            this.serverHttpUrl = serverHttpUrl;
            this.base64codec = new Base64(0);
            this.httpContext = new BasicHttpContext();
            this.httpContext.setAttribute(SERVER_HTTP_URL, (Object)serverHttpUrl);
        }

        @Override
        public String run() throws Exception {
            Oid mechOid = new Oid("1.2.840.113554.1.2.2");
            Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName(this.serverPrincipal, krb5PrincipalOid);
            GSSContext gssContext = manager.createContext(serverName, mechOid, null, 0);
            gssContext.requestMutualAuth(false);
            byte[] inToken = new byte[]{};
            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
            gssContext.dispose();
            return new String(this.base64codec.encode(outToken));
        }
    }
}

