/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.services.dataflow.model.Source;
import com.google.api.services.dataflow.model.SourceMetadata;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.dataflow.TransformTranslator;
import org.apache.beam.runners.dataflow.internal.CustomSources;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ReadTranslator
implements TransformTranslator<SplittableParDo.PrimitiveBoundedRead<?>> {
    ReadTranslator() {
    }

    @Override
    public void translate(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveBoundedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
        ReadTranslator.translateReadHelper(transform.getSource(), transform, context);
    }

    public static <T> void translateReadHelper(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.io.Source<T> source, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
        try {
            TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "ParallelRead");
            stepContext.addInput("format", "custom_source");
            stepContext.addInput("custom_source_step_input", ReadTranslator.cloudSourceToDictionary(CustomSources.serializeToCloudSource(source, context.getPipelineOptions())));
            stepContext.addOutput("output", context.getOutput(transform));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> cloudSourceToDictionary(@UnknownKeyFor @NonNull @Initialized Source source) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Structs.addDictionary(res, "spec", source.getSpec());
        if (source.getMetadata() != null) {
            Structs.addDictionary(res, "metadata", ReadTranslator.cloudSourceMetadataToDictionary(source.getMetadata()));
        }
        if (source.getDoesNotNeedSplitting() != null) {
            Structs.addBoolean(res, "does_not_need_splitting", source.getDoesNotNeedSplitting());
        }
        return res;
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> cloudSourceMetadataToDictionary(@UnknownKeyFor @NonNull @Initialized SourceMetadata metadata) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (metadata.getEstimatedSizeBytes() != null) {
            Structs.addLong(res, "estimated_size_bytes", metadata.getEstimatedSizeBytes());
        }
        if (metadata.getInfinite() != null) {
            Structs.addBoolean(res, "is_infinite", metadata.getInfinite());
        }
        return res;
    }
}

