<!--
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
-->
# How To Contribute

Apache Hop is developed by an open and friendly community. Everybody is cordially welcome to join the community and contribute to Apache Hop. There are several ways to interact with the community and to contribute to Hop including asking questions, filing bug reports, proposing new features, joining discussions on the mailing lists, contributing code or documentation, improving the website, or testing release candidates.

## What do you want to do?
Contributing to Hop goes beyond writing code for the project. Below, we list different opportunities to help the project:

* To report a problem with Hop, open a Hop's [GitHub Issue](https://github.com/apache/hop/issues), log in if necessary, and click on the "+" in the left side bar (Shortcut "c").
Please give detailed information about the problem you encountered and, if possible, add a description that helps to reproduce the problem. For more information go to our [info](https://hop.apache.org/community/contribution-guides/github-guide/) page. 
* Read the [Code Contribution Guide](https://hop.apache.org/community/contribution-guides/code-contribution-guide/)
* Help With Code Reviews [Code Review Guide](https://hop.apache.org/community/contribution-guides/code-review-guide/)
* Help Prepare a Release[Release Review Guide](https://hop.apache.org/community/contribution-guides/release-contribution-guide/)
* Contribute with Documentation [Documentation Contribution Guide](https://hop.apache.org/community/contribution-guides/documentation-contribution-guide/)
* Translate Hop [Translation Contribution Guide](https://hop.apache.org/community/contribution-guides/translation-contribution-guide/)
* Support Hop Users
  * Join us on our [Mattermost](https://chat.project-hop.org/) server and answer questions
  * Reply to Hop related questions on Stack Overflow with the hop tag or the Hop forums
  * Check the latest issues in GtiHub Issues for tickets which are actually user questions
* Improve the Website [Website Contribution Guide](https://hop.apache.org/community/contribution-guides/website-contribution-guide/)
* Spread the Word about Hop
  * Organize or attend a Hop Meetup
  * Contribute to the Hop blog (coming soon)


Any other questions? Reach out on the Hop [chat](https://chat.project-hop.org/) to get help.

## Further Reading
### Submit a Contributor License Agreement
Please submit a contributor license agreement to the Apache Hop if you are contributing a lot of code to Apache Hop. The following quote from http://www.apache.org/licenses gives more information about the ICLA and CCLA and why they are necessary.

>Apache Licenses
> 
>The ASF desires that all contributors of ideas, code, or documentation to the Apache projects complete, sign, and submit (via postal mail, fax or email) an Individual Contributor License Agreement (CLA) [ PDF form ]. The purpose of this agreement is to clearly define the terms under which intellectual property has been contributed to the ASF and thereby allow us to defend the project should there be a legal dispute regarding the software at some future time. A signed CLA is required to be on file before an individual is given commit rights to an ASF project.
>
>For a corporation that has assigned employees to work on an Apache project, a Corporate CLA (CCLA) is available for contributing intellectual property via the corporation, that may have been assigned as part of an employment agreement. Note that a Corporate CLA does not remove the need for every developer to sign their own CLA as an individual, to cover any of their contributions which are not owned by the corporation signing the CCLA.

## Becoming a Hop Committer and PMC member
### How to become a committer

Committers are community members that have write access to the project’s repositories, i.e., they can modify the code, documentation, and website by themselves and also accept other contributions.

There is no strict protocol for becoming a committer or PMC member. Candidates for new committers are typically people that are active contributors and community members.

As in all Apache projects, candidates for new committers are suggested by current committers or PMC members, and voted upon by the PMC.

If you would like to become a committer, we encourage you to engage with the community and start contributing to Apache Hop in any possible way. Contributions come in many shapes and forms, and the Hop community appreciates every contributor and contribution. You might also want to talk to other committers and ask for their advice and guidance.
