/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ClosingAction;
import net.sf.saxon.om.ClosingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public final class CardinalityChecker
extends UnaryExpression {
    private int requiredCardinality = -1;
    private RoleLocator role;

    private CardinalityChecker(Expression expression, int n, RoleLocator roleLocator) {
        super(expression);
        this.requiredCardinality = n;
        this.role = roleLocator;
        this.computeStaticProperties();
        this.adoptChildExpression(expression);
    }

    public static ComputedExpression makeCardinalityChecker(Expression expression, int n, RoleLocator roleLocator) {
        if (expression instanceof Atomizer && !Cardinality.allowsMany(n)) {
            Expression expression2 = ((Atomizer)expression).getBaseExpression();
            if (expression2 instanceof ComputedExpression) {
                ((ComputedExpression)expression2).setParentExpression(expression.getParentExpression());
            }
            return new SingletonAtomizer(expression2, roleLocator, Cardinality.allowsZero(n));
        }
        return new CardinalityChecker(expression, n, roleLocator);
    }

    public int getRequiredCardinality() {
        return this.requiredCardinality;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        if (this.requiredCardinality == 57344) {
            return this.operand;
        }
        if (Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        if (this.requiredCardinality == 57344) {
            return this.operand;
        }
        if (Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        return this;
    }

    public void setErrorCode(String string) {
        this.role.setErrorCode(string);
    }

    public int getImplementationMethod() {
        int n = 6;
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            n |= 1;
        }
        return n;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object object;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        if ((sequenceIterator.getProperties() & 2) != 0) {
            int n = ((LastPositionFinder)sequenceIterator).getLastPosition();
            if (n == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            }
            if (n > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            }
            return sequenceIterator;
        }
        if (!Cardinality.allowsZero(this.requiredCardinality)) {
            object = xPathContext;
            ClosingAction closingAction = new ClosingAction((XPathContext)object){
                private final /* synthetic */ XPathContext val$callingContext;
                {
                    this.val$callingContext = xPathContext;
                }

                public void close(SequenceIterator sequenceIterator, int n) throws XPathException {
                    if (n == 0) {
                        CardinalityChecker.this.typeError("An empty sequence is not allowed as the " + CardinalityChecker.this.role.getMessage(), CardinalityChecker.this.role.getErrorCode(), this.val$callingContext);
                    }
                }
            };
            sequenceIterator = new ClosingIterator(sequenceIterator, closingAction);
        }
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            object = new CardinalityCheckingFunction();
            ((CardinalityCheckingFunction)object).iterator = sequenceIterator;
            sequenceIterator = new MappingIterator(sequenceIterator, (MappingFunction)object, null);
        }
        return sequenceIterator;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        Item item2 = null;
        while ((item = sequenceIterator.next()) != null) {
            if (item2 != null) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
                return null;
            }
            item2 = item;
        }
        if (item2 == null && !Cardinality.allowsZero(this.requiredCardinality)) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            return null;
        }
        return item2;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Expression expression = this.operand;
        ItemType itemType = Type.ITEM_TYPE;
        if (expression instanceof ItemChecker) {
            itemType = ((ItemChecker)expression).getRequiredType();
            expression = ((ItemChecker)expression).getBaseExpression();
        }
        if ((expression.getImplementationMethod() & 4) != 0 && !(itemType instanceof DocumentNodeTest)) {
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            TypeCheckingFilter typeCheckingFilter = new TypeCheckingFilter();
            typeCheckingFilter.setUnderlyingReceiver(sequenceReceiver);
            typeCheckingFilter.setPipelineConfiguration(sequenceReceiver.getPipelineConfiguration());
            typeCheckingFilter.setRequiredType(itemType, this.requiredCardinality, this.role);
            xPathContext.setReceiver(typeCheckingFilter);
            expression.process(xPathContext);
            typeCheckingFilter.close();
            xPathContext.setReceiver(sequenceReceiver);
        } else {
            super.process(xPathContext);
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.operand.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredCardinality == ((CardinalityChecker)object).requiredCardinality;
    }

    public String displayOperator(NamePool namePool) {
        return "checkCardinality (" + Cardinality.toString(this.requiredCardinality) + ')';
    }

    private class CardinalityCheckingFunction
    implements MappingFunction {
        public SequenceIterator iterator;

        private CardinalityCheckingFunction() {
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            if (this.iterator.position() == 2) {
                CardinalityChecker.this.typeError("A sequence of more than one item is not allowed as the " + CardinalityChecker.this.role.getMessage(), CardinalityChecker.this.role.getErrorCode(), xPathContext);
                return null;
            }
            return item;
        }
    }
}

