/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.schemamapping;

import java.util.HashMap;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMappingData;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMappingField;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMappingMeta;

public class SchemaMapping
extends BaseTransform<SchemaMappingMeta, SchemaMappingData> {
    private static final Class<?> PKG = SchemaMapping.class;

    public SchemaMapping(TransformMeta transformMeta, SchemaMappingMeta meta, SchemaMappingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SchemaMappingData)this.data).inputRowMeta = this.getInputRowMeta();
            ((SchemaMappingData)this.data).outputRowMeta = new RowMeta();
            ((SchemaMappingMeta)this.meta).getFields(((SchemaMappingData)this.data).outputRowMeta, this.getTransformName(), null, null, this.variables, this.metadataProvider);
            ((SchemaMappingData)this.data).positionsMap = new HashMap();
            for (int i = 0; i < ((SchemaMappingMeta)this.meta).getMappingFieldset().size(); ++i) {
                SchemaMappingField f = ((SchemaMappingMeta)this.meta).getMappingFieldset().get(i);
                if (((SchemaMappingData)this.data).inputRowMeta.searchValueMeta(f.getFieldStream()) != null) {
                    ((SchemaMappingData)this.data).positionsMap.put(f.getFieldSchemaDefinition(), ((SchemaMappingData)this.data).inputRowMeta.indexOfValue(f.getFieldStream()));
                }
                IValueMeta sourceValueMeta = ((SchemaMappingData)this.data).inputRowMeta.getValueMeta(((SchemaMappingData)this.data).inputRowMeta.indexOfValue(f.getFieldStream()));
                IValueMeta targetValueMeta = ((SchemaMappingData)this.data).outputRowMeta.getValueMeta(((SchemaMappingData)this.data).outputRowMeta.indexOfValue(f.getFieldSchemaDefinition()));
                this.alterSourceMetadata(sourceValueMeta, targetValueMeta);
            }
        }
        Object[] outputData = new Object[((SchemaMappingData)this.data).outputRowMeta.size()];
        this.applySchemaToIncomingStream(outputData, r);
        this.putRow(((SchemaMappingData)this.data).outputRowMeta, outputData);
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"SchemaMapping.Log.WroteRowToNextTransform", (String[])new String[0]) + ((SchemaMappingData)this.data).outputRowMeta.getString(outputData));
        }
        return true;
    }

    private void alterSourceMetadata(IValueMeta sourceValueMeta, IValueMeta targetValueMeta) {
        if (!Utils.isEmpty((CharSequence)targetValueMeta.getConversionMask())) {
            sourceValueMeta.setConversionMask(targetValueMeta.getConversionMask());
        }
        if (!Utils.isEmpty((CharSequence)targetValueMeta.getDecimalSymbol())) {
            sourceValueMeta.setDecimalSymbol(targetValueMeta.getDecimalSymbol());
        }
        if (!Utils.isEmpty((CharSequence)targetValueMeta.getGroupingSymbol())) {
            sourceValueMeta.setGroupingSymbol(targetValueMeta.getGroupingSymbol());
        }
        if (!Utils.isEmpty((CharSequence)targetValueMeta.getCurrencySymbol())) {
            sourceValueMeta.setCurrencySymbol(targetValueMeta.getCurrencySymbol());
        }
    }

    private void applySchemaToIncomingStream(Object[] outputData, Object[] r) throws HopValueException {
        int outputIndex = 0;
        for (int i = 0; i < outputData.length; ++i) {
            IValueMeta targetRowMeta = ((SchemaMappingData)this.data).outputRowMeta.getValueMeta(i);
            Integer pos = ((SchemaMappingData)this.data).positionsMap.get(targetRowMeta.getName());
            if (pos != null) {
                IValueMeta valueMeta = ((SchemaMappingData)this.data).inputRowMeta.getValueMeta(pos.intValue());
                outputData[outputIndex++] = targetRowMeta.convertData(valueMeta, r[pos]);
                continue;
            }
            outputData[outputIndex++] = null;
        }
    }

    public boolean init() {
        return super.init();
    }
}

