/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.debug.PipelineDebugMeta;
import org.apache.hop.pipeline.debug.TransformDebugMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.dialog.PipelineDialog;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public class PipelinePreviewProgressDialog {
    private static final Class<?> PKG = PipelineDialog.class;
    private final Shell shell;
    private final IVariables variables;
    private PipelineMeta pipelineMeta;
    private final String[] previewTransformNames;
    private final int[] previewSize;
    private Pipeline pipeline;
    private boolean cancelled;
    private String loggingText;
    private PipelineDebugMeta pipelineDebugMeta;

    public PipelinePreviewProgressDialog(Shell shell, IVariables variables, PipelineMeta pipelineMeta, String[] previewTransformNames, int[] previewSize) {
        this.shell = shell;
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.previewTransformNames = previewTransformNames;
        this.previewSize = previewSize;
        this.cancelled = false;
    }

    public PipelineMeta open() {
        return this.open(true);
    }

    public PipelineMeta open(boolean showErrorDialogs) {
        HopGui hopGui = HopGui.getInstance();
        if (!EnvironmentUtils.getInstance().isWeb()) {
            IRunnableWithProgress op = monitor -> this.doPreview(hopGui, monitor, showErrorDialogs);
            try {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
                Runnable run = () -> {
                    IProgressMonitor monitor = pmd.getProgressMonitor();
                    while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (monitor.isCanceled()) {
                        try {
                            this.pipeline.stopAll();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                new Thread(run).start();
                pmd.run(true, op);
            }
            catch (InterruptedException | InvocationTargetException e) {
                if (showErrorDialogs) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelinePreviewProgressDialog.ErrorLoadingPipeline.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelinePreviewProgressDialog.ErrorLoadingPipeline.DialogMessage", (String[])new String[0]), e);
                }
                this.pipelineMeta = null;
            }
        } else {
            Cursor cursor = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(cursor);
            this.doPreview(hopGui, null, showErrorDialogs);
        }
        return this.pipelineMeta;
    }

    private void doPreview(HopGui hopGui, IProgressMonitor progressMonitor, boolean showErrorDialogs) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(BaseMessages.getString(PKG, (String)"PipelinePreviewProgressDialog.Monitor.BeginTask.Title", (String[])new String[0]), 100);
        }
        this.pipeline = new LocalPipelineEngine(this.pipelineMeta, this.variables, hopGui.getLoggingObject());
        this.pipeline.setPreview(true);
        this.pipeline.setMetadataProvider((IHopMetadataProvider)hopGui.getMetadataProvider());
        try {
            this.pipeline.prepareExecution();
        }
        catch (HopException e) {
            if (showErrorDialogs) {
                this.shell.getDisplay().asyncExec(() -> new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelinePreviewProgressDialog.Exception.ErrorPreparingPipeline", (String[])new String[0]), (Exception)((Object)e)));
            }
            if (progressMonitor != null && !progressMonitor.isCanceled()) {
                progressMonitor.done();
            }
            return;
        }
        this.pipelineDebugMeta = new PipelineDebugMeta(this.pipelineMeta);
        for (int i = 0; i < this.previewTransformNames.length; ++i) {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.previewTransformNames[i]);
            TransformDebugMeta transformDebugMeta2 = new TransformDebugMeta(transformMeta);
            transformDebugMeta2.setReadingFirstRows(true);
            transformDebugMeta2.setRowCount(this.previewSize[i]);
            this.pipelineDebugMeta.getTransformDebugMetaMap().put(transformMeta, transformDebugMeta2);
        }
        int previousPct = 0;
        ArrayList previewComplete = new ArrayList();
        this.pipelineDebugMeta.addBreakPointListers((pipelineDebugMeta, transformDebugMeta, rowBufferMeta, rowBuffer) -> {
            String transformName = transformDebugMeta.getTransformMeta().getName();
            previewComplete.add(transformName);
            if (progressMonitor != null) {
                progressMonitor.subTask(BaseMessages.getString(PKG, (String)"PipelinePreviewProgressDialog.SubTask.TransformPreviewFinished", (String[])new String[]{transformName}));
            }
        });
        this.pipelineDebugMeta.addRowListenersToPipeline((IPipelineEngine)this.pipeline);
        try {
            this.pipeline.startThreads();
        }
        catch (HopException e) {
            this.shell.getDisplay().asyncExec(() -> new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelinePreviewProgressDialog.Exception.ErrorPreparingPipeline", (String[])new String[0]), (Exception)((Object)e)));
            return;
        }
        while (!(previewComplete.size() >= this.previewTransformNames.length || this.pipeline.isFinished() || progressMonitor != null && progressMonitor.isCanceled())) {
            int nrDone = 0;
            int nrTotal = 0;
            for (TransformDebugMeta transformDebugMeta3 : this.pipelineDebugMeta.getTransformDebugMetaMap().values()) {
                nrDone += transformDebugMeta3.getRowBuffer().size();
                nrTotal += transformDebugMeta3.getRowCount();
            }
            int pct = 100 * nrDone / nrTotal;
            int worked = pct - previousPct;
            if (progressMonitor != null && worked > 0) {
                progressMonitor.worked(worked);
            }
            previousPct = pct;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (progressMonitor == null || !progressMonitor.isCanceled()) continue;
            this.cancelled = true;
            this.pipeline.stopAll();
        }
        this.pipeline.stopAll();
        this.loggingText = HopLogStore.getAppender().getBuffer(this.pipeline.getLogChannel().getLogChannelId(), true).toString();
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    public List<Object[]> getPreviewRows(String transformName) {
        if (this.pipelineDebugMeta == null) {
            return null;
        }
        for (TransformMeta transformMeta : this.pipelineDebugMeta.getTransformDebugMetaMap().keySet()) {
            if (!transformMeta.getName().equals(transformName)) continue;
            TransformDebugMeta transformDebugMeta = (TransformDebugMeta)this.pipelineDebugMeta.getTransformDebugMetaMap().get(transformMeta);
            return transformDebugMeta.getRowBuffer();
        }
        return null;
    }

    public IRowMeta getPreviewRowsMeta(String transformName) {
        if (this.pipelineDebugMeta == null) {
            return null;
        }
        for (TransformMeta transformMeta : this.pipelineDebugMeta.getTransformDebugMetaMap().keySet()) {
            if (!transformMeta.getName().equals(transformName)) continue;
            TransformDebugMeta transformDebugMeta = (TransformDebugMeta)this.pipelineDebugMeta.getTransformDebugMetaMap().get(transformMeta);
            return transformDebugMeta.getRowBufferMeta();
        }
        return null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getLoggingText() {
        return this.loggingText;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public PipelineDebugMeta getPipelineDebugMeta() {
        return this.pipelineDebugMeta;
    }
}

