/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartitionsRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildPartitionsRecordAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ChildPartitionsRecordAction.class);
    private final @UnknownKeyFor @NonNull @Initialized PartitionMetadataDao partitionMetadataDao;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;

    ChildPartitionsRecordAction(@UnknownKeyFor @NonNull @Initialized PartitionMetadataDao partitionMetadataDao, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.partitionMetadataDao = partitionMetadataDao;
        this.metrics = metrics;
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation> run(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized ChildPartitionsRecord record, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) {
        String token = partition.getPartitionToken();
        LOG.debug("[{}] Processing child partition record {}", (Object)token, (Object)record);
        Timestamp startTimestamp = record.getStartTimestamp();
        Instant startInstant = new Instant(startTimestamp.toSqlTimestamp().getTime());
        if (!tracker.tryClaim((Object)startTimestamp)) {
            LOG.debug("[{}] Could not claim queryChangeStream({}), stopping", (Object)token, (Object)startTimestamp);
            return Optional.of(DoFn.ProcessContinuation.stop());
        }
        watermarkEstimator.setWatermark(startInstant);
        for (ChildPartition childPartition : record.getChildPartitions()) {
            this.processChildPartition(partition, record, childPartition);
        }
        LOG.debug("[{}] Child partitions action completed successfully", (Object)token);
        return Optional.empty();
    }

    private void processChildPartition(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized ChildPartitionsRecord record, @UnknownKeyFor @NonNull @Initialized ChildPartition childPartition) {
        String partitionToken = partition.getPartitionToken();
        String childPartitionToken = childPartition.getToken();
        boolean isSplit = this.isSplit(childPartition);
        LOG.debug("[{}] Processing child partition {} event", (Object)partitionToken, (Object)(isSplit ? "split" : "merge"));
        PartitionMetadata row = this.toPartitionMetadata(record.getStartTimestamp(), partition.getEndTimestamp(), partition.getHeartbeatMillis(), childPartition);
        LOG.debug("[{}] Inserting child partition token {}", (Object)partitionToken, (Object)childPartitionToken);
        Boolean insertedRow = this.partitionMetadataDao.runInTransaction(transaction -> {
            if (transaction.getPartition(childPartitionToken) == null) {
                transaction.insert(row);
                return true;
            }
            return false;
        }, "InsertChildPartition").getResult();
        if (insertedRow.booleanValue() && isSplit) {
            this.metrics.incPartitionRecordSplitCount();
        } else if (insertedRow.booleanValue()) {
            this.metrics.incPartitionRecordMergeCount();
        } else {
            LOG.debug("[{}] Child token {} already exists, skipping...", (Object)partitionToken, (Object)childPartitionToken);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isSplit(@UnknownKeyFor @NonNull @Initialized ChildPartition childPartition) {
        return childPartition.getParentTokens().size() == 1;
    }

    private @UnknownKeyFor @NonNull @Initialized PartitionMetadata toPartitionMetadata(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp, @UnknownKeyFor @NonNull @Initialized long heartbeatMillis, @UnknownKeyFor @NonNull @Initialized ChildPartition childPartition) {
        return PartitionMetadata.newBuilder().setPartitionToken(childPartition.getToken()).setParentTokens(childPartition.getParentTokens()).setStartTimestamp(startTimestamp).setEndTimestamp(endTimestamp).setHeartbeatMillis(heartbeatMillis).setState(PartitionMetadata.State.CREATED).setWatermark(startTimestamp).build();
    }
}

