/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.FallbackStorage;
import org.apache.spark.storage.NoopRpcEndpointRef;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FallbackStorage$
implements Logging {
    public static FallbackStorage$ MODULE$;
    private final BlockManagerId FALLBACK_BLOCK_MANAGER_ID;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FallbackStorage$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManagerId FALLBACK_BLOCK_MANAGER_ID() {
        return this.FALLBACK_BLOCK_MANAGER_ID;
    }

    public Option<FallbackStorage> getFallbackStorage(SparkConf conf) {
        if (((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined()) {
            return new Some((Object)new FallbackStorage(conf));
        }
        return None$.MODULE$;
    }

    public void registerBlockManagerIfNeeded(BlockManagerMaster master, SparkConf conf) {
        if (((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined()) {
            master.registerBlockManager(this.FALLBACK_BLOCK_MANAGER_ID(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L, new NoopRpcEndpointRef(conf), master.registerBlockManager$default$6());
            return;
        }
    }

    public void cleanUp(SparkConf conf, Configuration hadoopConf) {
        if (((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined() && BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_CLEANUP())) && conf.contains("spark.app.id")) {
            Path fallbackPath = new Path((String)((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).get(), conf.getAppId());
            URI fallbackUri = fallbackPath.toUri();
            FileSystem fallbackFileSystem = FileSystem.get((URI)fallbackUri, (Configuration)hadoopConf);
            if (fallbackFileSystem.exists(fallbackPath)) {
                if (fallbackFileSystem.delete(fallbackPath, true)) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Succeed to clean up: ").append(fallbackUri).toString());
                    return;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Failed to clean up: ").append(fallbackUri).toString());
                return;
            }
            return;
        }
    }

    public boolean org$apache$spark$storage$FallbackStorage$$reportBlockStatus(BlockManager blockManager, BlockId blockId, long dataLength) {
        Predef$.MODULE$.assert(blockManager.master() != null);
        return blockManager.master().updateBlockInfo(this.FALLBACK_BLOCK_MANAGER_ID(), blockId, StorageLevel$.MODULE$.DISK_ONLY(), 0L, dataLength);
    }

    public ManagedBuffer read(SparkConf conf, BlockId blockId) {
        Tuple4 tuple4;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(5).append("Read ").append(blockId).toString());
        Path fallbackPath = new Path((String)((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).get());
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(conf);
        FileSystem fallbackFileSystem = FileSystem.get((URI)fallbackPath.toUri(), (Configuration)hadoopConf);
        String appId = conf.getAppId();
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw new IllegalArgumentException(new StringBuilder(36).append("unexpected shuffle block id format: ").append(blockId).toString());
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        String name = new ShuffleIndexBlockId(shuffleId2, mapId2, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()).name();
        int hash = JavaUtils.nonNegativeHash((Object)name);
        Path indexFile = new Path(fallbackPath, new StringBuilder(3).append(appId).append("/").append(shuffleId2).append("/").append(hash).append("/").append(name).toString());
        long start = (long)startReduceId2 * 8L;
        long end = (long)endReduceId2 * 8L;
        return (ManagedBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> fallbackFileSystem.open(indexFile), (Function1 & Serializable & scala.Serializable)inputStream -> (NioManagedBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new DataInputStream((InputStream)inputStream), (Function1 & Serializable & scala.Serializable)index -> {
            index.skip(start);
            long offset = index.readLong();
            index.skip(end - (start + 8L));
            long nextOffset = index.readLong();
            String name = new ShuffleDataBlockId(shuffleId2, mapId2, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()).name();
            int hash = JavaUtils.nonNegativeHash((Object)name);
            Path dataFile = new Path(fallbackPath, new StringBuilder(3).append(appId).append("/").append(shuffleId2).append("/").append(hash).append("/").append(name).toString());
            long size = nextOffset - offset;
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("To byte array ").append(size).toString());
            byte[] array = new byte[(int)size];
            long startTimeNs = System.nanoTime();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> fallbackFileSystem.open(dataFile), (Function1 & Serializable & scala.Serializable)f -> {
                FallbackStorage$.$anonfun$read$8(offset, array, startTimeNs, f);
                return BoxedUnit.UNIT;
            });
            return new NioManagedBuffer(ByteBuffer.wrap(array));
        }));
    }

    public static final /* synthetic */ void $anonfun$read$8(long offset$1, byte[] array$1, long startTimeNs$1, FSDataInputStream f) {
        f.seek(offset$1);
        f.readFully(array$1);
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Took ").append((System.nanoTime() - startTimeNs$1) / 1000000L).append("ms").toString());
    }

    private FallbackStorage$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.FALLBACK_BLOCK_MANAGER_ID = BlockManagerId$.MODULE$.apply("fallback", "remote", 7337, BlockManagerId$.MODULE$.apply$default$4());
    }
}

