/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.FnHarness;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.fn.server.InProcessServerFactory;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedEnvironmentFactory
implements EnvironmentFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(EmbeddedEnvironmentFactory.class);
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> loggingServer;
    private final @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> controlServer;
    private final @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource;

    public static @UnknownKeyFor @NonNull @Initialized EnvironmentFactory create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> loggingServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> controlServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource) {
        return new EmbeddedEnvironmentFactory(options, loggingServer, controlServer, clientSource);
    }

    private EmbeddedEnvironmentFactory(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> loggingServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> controlServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource) {
        this.options = options;
        this.loggingServer = loggingServer;
        this.controlServer = controlServer;
        Preconditions.checkArgument(loggingServer.getApiServiceDescriptor() != null, "Logging Server cannot have a null %s", (Object)Endpoints.ApiServiceDescriptor.class.getSimpleName());
        Preconditions.checkArgument(controlServer.getApiServiceDescriptor() != null, "Control Server cannot have a null %s", (Object)Endpoints.ApiServiceDescriptor.class.getSimpleName());
        this.clientSource = clientSource;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RemoteEnvironment createEnvironment(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment, @UnknownKeyFor @NonNull @Initialized String workerId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CreateEnvironment-thread").build());
        Future<Object> fnHarness = executor.submit(() -> {
            try {
                FnHarness.main((String)workerId, (PipelineOptions)this.options, Collections.singleton(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRunnerProtocols.Enum.CONTROL_RESPONSE_ELEMENTS_EMBEDDING)), (Endpoints.ApiServiceDescriptor)this.loggingServer.getApiServiceDescriptor(), (Endpoints.ApiServiceDescriptor)this.controlServer.getApiServiceDescriptor(), null, (ManagedChannelFactory)ManagedChannelFactory.createInProcess(), (OutboundObserverFactory)OutboundObserverFactory.clientDirect(), (Cache)Caches.fromOptions((PipelineOptions)this.options));
            }
            catch (NoClassDefFoundError e) {
                LOG.error("{} while executing an in-process FnHarness. To use the {}, the 'org.apache.beam:beam-sdks-java-harness' artifact and its dependencies must be on the classpath", new Object[]{NoClassDefFoundError.class.getSimpleName(), EmbeddedEnvironmentFactory.class.getSimpleName(), e});
                throw e;
            }
            return null;
        });
        executor.submit(() -> {
            try {
                fnHarness.get();
            }
            catch (Throwable t) {
                executor.shutdownNow();
            }
        });
        InstructionRequestHandler handler = null;
        while (handler == null) {
            try {
                if (executor.isShutdown()) {
                    throw new IllegalStateException("FnHarness startup failed");
                }
                handler = this.clientSource.take(workerId, Duration.ofSeconds(5L));
            }
            catch (TimeoutException timeoutEx) {
                LOG.info("Still waiting for startup of FnHarness");
            }
            catch (InterruptedException interruptEx) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptEx);
            }
        }
        return RemoteEnvironment.forHandler(environment, handler);
    }

    public static class Provider
    implements EnvironmentFactory.Provider {
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;

        public Provider(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            this.pipelineOptions = pipelineOptions;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized EnvironmentFactory createEnvironmentFactory(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> controlServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> loggingServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService> retrievalServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool clientPool, @UnknownKeyFor @NonNull @Initialized IdGenerator idGenerator) {
            return EmbeddedEnvironmentFactory.create(this.pipelineOptions, loggingServer, controlServer, clientPool.getSource());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ServerFactory getServerFactory() {
            return InProcessServerFactory.create();
        }
    }
}

