/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.io.range.OffsetRangeTracker;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OffsetBasedSource<@UnknownKeyFor T>
extends BoundedSource<T> {
    private final @UnknownKeyFor @NonNull @Initialized long startOffset;
    private final @UnknownKeyFor @NonNull @Initialized long endOffset;
    private final @UnknownKeyFor @NonNull @Initialized long minBundleSize;

    public OffsetBasedSource(@UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long endOffset, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.minBundleSize = minBundleSize;
    }

    public @UnknownKeyFor @NonNull @Initialized long getStartOffset() {
        return this.startOffset;
    }

    public @UnknownKeyFor @NonNull @Initialized long getEndOffset() {
        return this.endOffset;
    }

    public @UnknownKeyFor @NonNull @Initialized long getMinBundleSize() {
        return this.minBundleSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long trueEndOffset = this.endOffset == Long.MAX_VALUE ? this.getMaxEndOffset(options) : this.endOffset;
        return this.getBytesPerOffset() * (trueEndOffset - this.getStartOffset());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long desiredBundleSizeOffsetUnits = Math.max(Math.max(1L, desiredBundleSizeBytes / this.getBytesPerOffset()), this.minBundleSize);
        ArrayList<OffsetBasedSource<T>> subSources = new ArrayList<OffsetBasedSource<T>>();
        for (OffsetRange range : new OffsetRange(this.startOffset, Math.min(this.endOffset, this.getMaxEndOffset(options))).split(desiredBundleSizeOffsetUnits, this.minBundleSize)) {
            subSources.add(this.createSourceForSubrange(range.getFrom(), range.getTo()));
        }
        return subSources;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.startOffset >= 0L, "Start offset has value %s, must be non-negative", this.startOffset);
        Preconditions.checkArgument(this.endOffset >= 0L, "End offset has value %s, must be non-negative", this.endOffset);
        Preconditions.checkArgument(this.startOffset <= this.endOffset, "Start offset %s may not be larger than end offset %s", this.startOffset, this.endOffset);
        Preconditions.checkArgument(this.minBundleSize >= 0L, "minBundleSize has value %s, must be non-negative", this.minBundleSize);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "[" + this.startOffset + ", " + this.endOffset + ")";
    }

    public @UnknownKeyFor @NonNull @Initialized long getBytesPerOffset() {
        return 1L;
    }

    public abstract @UnknownKeyFor @NonNull @Initialized long getMaxEndOffset(@UnknownKeyFor @NonNull @Initialized PipelineOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public abstract @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T> createSourceForSubrange(@UnknownKeyFor @NonNull @Initialized long var1, @UnknownKeyFor @NonNull @Initialized long var3);

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.addIfNotDefault(DisplayData.item("minBundleSize", this.minBundleSize).withLabel("Minimum Bundle Size"), 1L).addIfNotDefault(DisplayData.item("startOffset", this.startOffset).withLabel("Start Read Offset"), 0L).addIfNotDefault(DisplayData.item("endOffset", this.endOffset).withLabel("End Read Offset"), Long.MAX_VALUE);
    }

    public static abstract class OffsetBasedReader<@UnknownKeyFor T>
    extends BoundedSource.BoundedReader<T> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(OffsetBasedReader.class);
        private @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T> source;
        private final @UnknownKeyFor @NonNull @Initialized OffsetRangeTracker rangeTracker;

        public final @UnknownKeyFor @NonNull @Initialized boolean isDone() {
            return this.rangeTracker.isDone();
        }

        public final @UnknownKeyFor @NonNull @Initialized boolean isStarted() {
            return this.rangeTracker.isStarted();
        }

        public OffsetBasedReader(@UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T> source) {
            this.source = source;
            this.rangeTracker = new OffsetRangeTracker(source.getStartOffset(), source.getEndOffset());
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException;

        protected @UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return true;
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.startImpl() && this.rangeTracker.tryReturnRecordAt(this.isAtSplitPoint(), this.getCurrentOffset()) || this.rangeTracker.markDone();
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.advanceImpl() && this.rangeTracker.tryReturnRecordAt(this.isAtSplitPoint(), this.getCurrentOffset()) || this.rangeTracker.markDone();
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized boolean startImpl() throws @UnknownKeyFor @NonNull @Initialized IOException;

        protected abstract @UnknownKeyFor @NonNull @Initialized boolean advanceImpl() throws @UnknownKeyFor @NonNull @Initialized IOException;

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T> getCurrentSource() {
            return this.source;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Double getFractionConsumed() {
            return this.rangeTracker.getFractionConsumed();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getSplitPointsConsumed() {
            return this.rangeTracker.getSplitPointsProcessed();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
            if (this.isDone()) {
                return 0L;
            }
            if (!this.isStarted()) {
                return -1L;
            }
            if (!this.allowsDynamicSplitting()) {
                return 1L;
            }
            if (this.getCurrentOffset() >= this.rangeTracker.getStopPosition() - 1L) {
                return 1L;
            }
            return super.getSplitPointsRemaining();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean allowsDynamicSplitting() {
            return true;
        }

        @Override
        public final synchronized @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T> splitAtFraction(@UnknownKeyFor @NonNull @Initialized double fraction) {
            if (!this.allowsDynamicSplitting()) {
                return null;
            }
            if (this.rangeTracker.getStopPosition() == Long.MAX_VALUE) {
                LOG.debug("Refusing to split unbounded OffsetBasedReader {} at fraction {}", (Object)this.rangeTracker, (Object)fraction);
                return null;
            }
            long splitOffset = this.rangeTracker.getPositionForFractionConsumed(fraction);
            LOG.debug("Proposing to split OffsetBasedReader {} at fraction {} (offset {})", new Object[]{this.rangeTracker, fraction, splitOffset});
            long start = this.source.getStartOffset();
            long end = this.source.getEndOffset();
            OffsetBasedSource<T> primary = this.source.createSourceForSubrange(start, splitOffset);
            OffsetBasedSource<T> residual = this.source.createSourceForSubrange(splitOffset, end);
            if (!this.rangeTracker.trySplitAtPosition(splitOffset)) {
                return null;
            }
            this.source = primary;
            return residual;
        }
    }
}

