/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_RenameFields_RenamePair;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RenameFields {
    public static <T> @UnknownKeyFor @NonNull @Initialized Inner<T> create() {
        return new Inner();
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema.FieldType renameFieldType(@UnknownKeyFor @NonNull @Initialized Schema.FieldType inputType, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RenamePair> renames, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized Schema> renamedSchemasMap, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized BitSet> nestedFieldRenamedMap) {
        if (renames.isEmpty()) {
            return inputType;
        }
        switch (inputType.getTypeName()) {
            case ROW: {
                RenameFields.renameSchema(inputType.getRowSchema(), renames, renamedSchemasMap, nestedFieldRenamedMap);
                return Schema.FieldType.row(renamedSchemasMap.get(inputType.getRowSchema().getUUID()));
            }
            case ARRAY: {
                return Schema.FieldType.array(RenameFields.renameFieldType(inputType.getCollectionElementType(), renames, renamedSchemasMap, nestedFieldRenamedMap));
            }
            case ITERABLE: {
                return Schema.FieldType.iterable(RenameFields.renameFieldType(inputType.getCollectionElementType(), renames, renamedSchemasMap, nestedFieldRenamedMap));
            }
            case MAP: {
                return Schema.FieldType.map(RenameFields.renameFieldType(inputType.getMapKeyType(), renames, renamedSchemasMap, nestedFieldRenamedMap), RenameFields.renameFieldType(inputType.getMapValueType(), renames, renamedSchemasMap, nestedFieldRenamedMap));
            }
            case LOGICAL_TYPE: {
                throw new RuntimeException("RenameFields does not support renaming logical types.");
            }
        }
        return inputType;
    }

    @VisibleForTesting
    static void renameSchema(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RenamePair> renames, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized Schema> renamedSchemasMap, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized BitSet> nestedFieldRenamedMap) {
        HashMap<Integer, String> topLevelRenames = Maps.newHashMap();
        ArrayListMultimap<Integer, RenamePair> nestedRenames = ArrayListMultimap.create();
        for (RenamePair rename : renames) {
            FieldAccessDescriptor access = rename.getFieldAccessDescriptor();
            if (!access.fieldIdsAccessed().isEmpty()) {
                Integer fieldId = Iterables.getOnlyElement(access.fieldIdsAccessed());
                topLevelRenames.put(fieldId, rename.getNewName());
                continue;
            }
            Map.Entry<Integer, FieldAccessDescriptor> nestedAccess = Iterables.getOnlyElement(access.nestedFieldsById().entrySet());
            nestedFieldRenamedMap.computeIfAbsent(inputSchema.getUUID(), s -> new BitSet(inputSchema.getFieldCount())).set(nestedAccess.getKey());
            nestedRenames.put(nestedAccess.getKey(), RenamePair.of(nestedAccess.getValue(), rename.getNewName()));
        }
        Schema.Builder builder = Schema.builder();
        for (int i = 0; i < inputSchema.getFieldCount(); ++i) {
            Schema.Field field = inputSchema.getField(i);
            Schema.FieldType fieldType = field.getType();
            String newName = topLevelRenames.getOrDefault(i, field.getName());
            Collection nestedFieldRenames = nestedRenames.asMap().getOrDefault(i, Collections.emptyList());
            builder.addField(newName, RenameFields.renameFieldType(fieldType, nestedFieldRenames, renamedSchemasMap, nestedFieldRenamedMap));
        }
        renamedSchemasMap.put(inputSchema.getUUID(), builder.build());
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Row renameRow(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized Schema schema, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized BitSet nestedRenames, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized Schema> renamedSubSchemasMap, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized BitSet> nestedFieldRenamedMap) {
        if (nestedRenames == null || nestedRenames.isEmpty()) {
            return Row.withSchema(schema).attachValues(row.getValues());
        }
        ArrayList<Object> values = Lists.newArrayListWithCapacity(row.getValues().size());
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            if (nestedRenames.get(i)) {
                values.add(RenameFields.renameFieldValue(row.getValue(i), schema.getField(i).getType(), renamedSubSchemasMap, nestedFieldRenamedMap));
                continue;
            }
            values.add(row.getValue(i));
        }
        return Row.withSchema(schema).attachValues(values);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object renameFieldValue(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized Schema> renamedSubSchemas, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized BitSet> nestedFieldRenamed) {
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                ArrayList<Object> renamedValues = Lists.newArrayList();
                for (Object o : (List)value) {
                    renamedValues.add(RenameFields.renameFieldValue(o, fieldType.getCollectionElementType(), renamedSubSchemas, nestedFieldRenamed));
                }
                return renamedValues;
            }
            case MAP: {
                HashMap<Object, Object> renamedMap = Maps.newHashMap();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    renamedMap.put(RenameFields.renameFieldValue(entry.getKey(), fieldType.getMapKeyType(), renamedSubSchemas, nestedFieldRenamed), RenameFields.renameFieldValue(entry.getValue(), fieldType.getMapValueType(), renamedSubSchemas, nestedFieldRenamed));
                }
                return renamedMap;
            }
            case ROW: {
                return RenameFields.renameRow((Row)value, fieldType.getRowSchema(), nestedFieldRenamed.get(fieldType.getRowSchema().getUUID()), renamedSubSchemas, nestedFieldRenamed);
            }
        }
        return value;
    }

    public static class Inner<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RenamePair> renames;

        private Inner() {
            this.renames = Lists.newArrayList();
        }

        private Inner(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RenamePair> renames) {
            this.renames = renames;
        }

        public @UnknownKeyFor @NonNull @Initialized Inner<T> rename(@UnknownKeyFor @NonNull @Initialized String field, @UnknownKeyFor @NonNull @Initialized String newName) {
            return this.rename(FieldAccessDescriptor.withFieldNames(field), newName);
        }

        public @UnknownKeyFor @NonNull @Initialized Inner<T> rename(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor field, @UnknownKeyFor @NonNull @Initialized String newName) {
            ImmutableCollection newList = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.renames)).add(RenamePair.of(field, newName))).build();
            return new Inner<T>((List<RenamePair>)((Object)newList));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            final HashMap<UUID, Schema> renamedSchemasMap = Maps.newHashMap();
            final HashMap<UUID, BitSet> nestedFieldRenamedMap = Maps.newHashMap();
            List<RenamePair> resolvedRenames = this.renames.stream().map(r -> r.resolve(input.getSchema())).collect(Collectors.toList());
            RenameFields.renameSchema(input.getSchema(), resolvedRenames, renamedSchemasMap, nestedFieldRenamedMap);
            final Schema outputSchema = (Schema)renamedSchemasMap.get(input.getSchema().getUUID());
            final BitSet nestedRenames = (BitSet)nestedFieldRenamedMap.get(input.getSchema().getUUID());
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
                    o.output(RenameFields.renameRow(row, outputSchema, nestedRenames, renamedSchemasMap, nestedFieldRenamedMap));
                }
            }))).setRowSchema(outputSchema);
        }
    }

    @AutoValue
    static abstract class RenamePair
    implements Serializable {
        RenamePair() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccessDescriptor();

        abstract @UnknownKeyFor @NonNull @Initialized String getNewName();

        static @UnknownKeyFor @NonNull @Initialized RenamePair of(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized String newName) {
            return new AutoValue_RenameFields_RenamePair(fieldAccessDescriptor, newName);
        }

        @UnknownKeyFor @NonNull @Initialized RenamePair resolve(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            FieldAccessDescriptor resolved = this.getFieldAccessDescriptor().resolve(schema);
            if (!resolved.referencesSingleField()) {
                throw new IllegalArgumentException(resolved + " references multiple fields.");
            }
            return RenamePair.of(resolved, this.getNewName());
        }
    }
}

