/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class CombineFns {
    public static @UnknownKeyFor @NonNull @Initialized ComposeCombineFnBuilder compose() {
        return new ComposeCombineFnBuilder();
    }

    private static <OutputT> void checkUniqueness(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> registeredTags, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
        Preconditions.checkArgument(!registeredTags.contains(outputTag), "Cannot compose with tuple tag %s because it is already present in the composition.", outputTag);
    }

    private static void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized HasDisplayData> combineFns) {
        for (int i = 0; i < combineFns.size(); ++i) {
            HasDisplayData combineFn = combineFns.get(i);
            String token = "combineFn" + (i + 1);
            builder.add(DisplayData.item(token, combineFn.getClass()).withLabel("Combine Function"));
            builder.include(token, combineFn);
        }
    }

    private static class ComposedAccumulatorCoder
    extends StructuredCoder<Object[]> {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Object>> coders;
        private @UnknownKeyFor @NonNull @Initialized int codersCount;

        public ComposedAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Object>> coders) {
            this.coders = ImmutableList.copyOf(coders);
            this.codersCount = coders.size();
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkArgument(value.length == this.codersCount);
            if (value.length == 0) {
                return;
            }
            int lastIndex = this.codersCount - 1;
            for (int i = 0; i < lastIndex; ++i) {
                this.coders.get(i).encode(value[i], outStream);
            }
            this.coders.get(lastIndex).encode(value[lastIndex], outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Object[] ret = new Object[this.codersCount];
            if (this.codersCount == 0) {
                return ret;
            }
            int lastIndex = this.codersCount - 1;
            for (int i = 0; i < lastIndex; ++i) {
                ret[i] = this.coders.get(i).decode(inStream);
            }
            ret[lastIndex] = this.coders.get(lastIndex).decode(inStream, context);
            return ret;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return this.coders;
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            for (int i = 0; i < this.codersCount; ++i) {
                this.coders.get(i).verifyDeterministic();
            }
        }
    }

    private static class ProjectionIterable
    implements Iterable<Object> {
        private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> iterable;
        private final @UnknownKeyFor @NonNull @Initialized int column;

        private ProjectionIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> iterable, @UnknownKeyFor @NonNull @Initialized int column) {
            this.iterable = iterable;
            this.column = column;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Object> iterator() {
            final Iterator<Object[]> iter = this.iterable.iterator();
            return new Iterator<Object>(){

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Object next() {
                    return ((Object[])iter.next())[column];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class ComposedCombineFnWithContext<@UnknownKeyFor DataT>
    extends CombineWithContext.CombineFnWithContext<DataT, Object[], CoCombineResult> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<DataT, @UnknownKeyFor @NonNull @Initialized Object>> extractInputFns;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder>> combineInputCoders;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> combineFnWithContexts;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTags;
        private final @UnknownKeyFor @NonNull @Initialized int combineFnCount;

        private ComposedCombineFnWithContext() {
            this.extractInputFns = ImmutableList.of();
            this.combineInputCoders = ImmutableList.of();
            this.combineFnWithContexts = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedCombineFnWithContext(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized SerializableFunction<DataT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> extractInputFns, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder>> combineInputCoders, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> combineFnWithContexts, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            this.combineInputCoders = combineInputCoders;
            ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>> castedCombineFnWithContexts = combineFnWithContexts;
            this.combineFnWithContexts = castedCombineFnWithContexts;
            this.outputTags = outputTags;
            this.combineFnCount = this.combineFnWithContexts.size();
        }

        public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFnWithContext<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> globalCombineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFnWithContext<DataT>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList<Optional<Coder>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineInputCoders)).add(Optional.absent())).build(), (ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineFnWithContexts)).add(CombineFnUtil.toFnWithContext(globalCombineFn))).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFnWithContext<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, @UnknownKeyFor @NonNull @Initialized Coder<InputT> combineInputCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> globalCombineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFnWithContext<DataT>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList<Optional<Coder>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineInputCoders)).add(Optional.of(combineInputCoder))).build(), (ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineFnWithContexts)).add(CombineFnUtil.toFnWithContext(globalCombineFn))).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] createAccumulator(@UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.combineFnWithContexts.get(i).createAccumulator(c);
            }
            return accumsArray;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] addInput(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator, DataT value, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.combineFnWithContexts.get(i).addInput(accumulator[i], input, c);
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> accumulators, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator(c);
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.combineFnWithContexts.get(i).mergeAccumulators(new ProjectionIterable(accumulators, i), c);
            }
            return accum;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CoCombineResult extractOutput(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
            HashMap<TupleTag<?>, Object> valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.combineFnWithContexts.get(i).extractOutput(accumulator[i], c));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] compact(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.combineFnWithContexts.get(i).compact(accumulator[i], c);
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<DataT> dataCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            ArrayList<Coder<Object>> coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = this.combineInputCoders.get(i).isPresent() ? this.combineInputCoders.get(i).get() : registry.getOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.combineFnWithContexts.get(i).getAccumulatorCoder(registry, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.combineFnWithContexts);
        }
    }

    public static class ComposedCombineFn<@UnknownKeyFor DataT>
    extends Combine.CombineFn<DataT, Object[], CoCombineResult> {
        private final @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> combineFns;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder>> combineInputCoders;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<DataT, @UnknownKeyFor @NonNull @Initialized Object>> extractInputFns;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTags;
        private final @UnknownKeyFor @NonNull @Initialized int combineFnCount;

        private ComposedCombineFn() {
            this.extractInputFns = ImmutableList.of();
            this.combineInputCoders = ImmutableList.of();
            this.combineFns = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedCombineFn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized SerializableFunction<DataT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> extractInputFns, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder>> combineInputCoders, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ImmutableList< @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> combineFns, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            this.combineInputCoders = combineInputCoders;
            ImmutableList<Combine.CombineFn<?, ?, ?>> castedCombineFns = combineFns;
            this.combineFns = castedCombineFns;
            this.outputTags = outputTags;
            this.combineFnCount = this.combineFns.size();
        }

        public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFn<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFn<DataT>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (List<Optional<Coder>>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineInputCoders)).add(Optional.absent())).build()), (ImmutableList<Combine.CombineFn<?, ?, ?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineFns)).add(combineFn)).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFnWithContext<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            ArrayList<CombineWithContext.CombineFnWithContext<Object, Object, Object>> fnsWithContext = Lists.newArrayList();
            for (Combine.CombineFn<Object, Object, Object> fn : this.combineFns) {
                fnsWithContext.add(CombineFnUtil.toFnWithContext(fn));
            }
            return new ComposedCombineFnWithContext((ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineInputCoders)).add(Optional.absent())).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fnsWithContext)).add(combineFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFn<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, @UnknownKeyFor @NonNull @Initialized Coder combineInputCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFn<DataT>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (List<Optional<Coder>>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineInputCoders)).add(Optional.of(combineInputCoder))).build()), (ImmutableList<Combine.CombineFn<?, ?, ?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineFns)).add(combineFn)).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFnWithContext<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, @UnknownKeyFor @NonNull @Initialized Coder combineInputCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            List fnsWithContext = this.combineFns.stream().map(CombineFnUtil::toFnWithContext).collect(Collectors.toList());
            return new ComposedCombineFnWithContext((ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineInputCoders)).add(Optional.of(combineInputCoder))).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)fnsWithContext)).add(combineFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] createAccumulator() {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.combineFns.get(i).createAccumulator();
            }
            return accumsArray;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] addInput(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator, DataT value) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.combineFns.get(i).addInput(accumulator[i], input);
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> accumulators) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.combineFns.get(i).mergeAccumulators(new ProjectionIterable(accumulators, i));
            }
            return accum;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CoCombineResult extractOutput(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator) {
            HashMap<TupleTag<?>, Object> valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.combineFns.get(i).extractOutput(accumulator[i]));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] compact(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.combineFns.get(i).compact(accumulator[i]);
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<DataT> dataCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            ArrayList<Coder<Object>> coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = this.combineInputCoders.get(i).isPresent() ? this.combineInputCoders.get(i).get() : registry.getOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.combineFns.get(i).getAccumulatorCoder(registry, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.combineFns);
        }
    }

    public static class CoCombineResult
    implements Serializable {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Object> valuesMap;

        CoCombineResult(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Object> valuesMap) {
            ImmutableMap.Builder<TupleTag<?>, Object> builder = ImmutableMap.builder();
            for (Map.Entry<TupleTag<?>, Object> entry : valuesMap.entrySet()) {
                if (entry.getValue() != null) {
                    builder.put(entry);
                    continue;
                }
                builder.put(entry.getKey(), (Object)NullValue.INSTANCE);
            }
            this.valuesMap = builder.build();
        }

        public <V> @Nullable V get(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag) {
            Preconditions.checkArgument(this.valuesMap.keySet().contains(tag), "TupleTag " + tag + " is not in the CoCombineResult");
            Object value = this.valuesMap.get(tag);
            if (value == NullValue.INSTANCE) {
                return null;
            }
            return (V)value;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoCombineResult that = (CoCombineResult)o;
            return Objects.equal(this.valuesMap, that.valuesMap);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode(this.valuesMap);
        }

        private static enum NullValue {
            INSTANCE;

        }
    }

    public static class ComposeCombineFnBuilder {
        public <DataT, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFn<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            return new ComposedCombineFn<DataT>().with(extractInputFn, combineFn, outputTag);
        }

        public <DataT, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFn<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, @UnknownKeyFor @NonNull @Initialized Coder combineInputCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            return new ComposedCombineFn<DataT>().with(extractInputFn, combineInputCoder, combineFn, outputTag);
        }

        public <DataT, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFnWithContext<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFnWithContext, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            return new ComposedCombineFnWithContext<DataT>().with(extractInputFn, combineFnWithContext, outputTag);
        }

        public <DataT, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ComposedCombineFnWithContext<DataT> with(@UnknownKeyFor @NonNull @Initialized SimpleFunction<DataT, InputT> extractInputFn, @UnknownKeyFor @NonNull @Initialized Coder combineInputCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFnWithContext, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            return new ComposedCombineFnWithContext<DataT>().with(extractInputFn, combineInputCoder, combineFnWithContext, outputTag);
        }
    }
}

