/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.PeriodicSequence;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class PeriodicImpulse
extends PTransform<PBegin, PCollection<Instant>> {
    @UnknownKeyFor @NonNull @Initialized Instant startTimestamp = Instant.now();
    @UnknownKeyFor @NonNull @Initialized Instant stopTimestamp = BoundedWindow.TIMESTAMP_MAX_VALUE;
    @Nullable @UnknownKeyFor @Initialized Duration stopDuration;
    @UnknownKeyFor @NonNull @Initialized Duration fireInterval = Duration.standardMinutes((long)1L);
    @UnknownKeyFor @NonNull @Initialized boolean applyWindowing = false;
    @UnknownKeyFor @NonNull @Initialized boolean catchUpToNow = true;

    private PeriodicImpulse() {
    }

    public static @UnknownKeyFor @NonNull @Initialized PeriodicImpulse create() {
        return new PeriodicImpulse();
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse startAt(@UnknownKeyFor @NonNull @Initialized Instant startTime) {
        Preconditions.checkArgument(this.stopDuration == null, "startAt and stopAfter cannot be set at the same time");
        this.startTimestamp = startTime;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse stopAt(@UnknownKeyFor @NonNull @Initialized Instant stopTime) {
        Preconditions.checkArgument(this.stopDuration == null, "stopAt and stopAfter cannot be set at the same time");
        this.stopTimestamp = stopTime;
        return this;
    }

    @Internal
    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse stopAfter(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        this.stopDuration = duration;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse withInterval(@UnknownKeyFor @NonNull @Initialized Duration interval) {
        this.fireInterval = interval;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse applyWindowing() {
        this.applyWindowing = true;
        return this;
    }

    @Internal
    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse catchUpToNow(@UnknownKeyFor @NonNull @Initialized boolean catchUpToNow) {
        this.catchUpToNow = catchUpToNow;
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Instant> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        PCollection seqDef;
        if (this.stopDuration != null) {
            Duration d = this.stopDuration;
            seqDef = (PCollection)((Object)input.apply(Impulse.create()).apply(ParDo.of(new RuntimeSequenceFn(d, this.fireInterval, this.catchUpToNow))));
        } else {
            seqDef = (PCollection)input.apply(Create.of(new PeriodicSequence.SequenceDefinition(this.startTimestamp, this.stopTimestamp, this.fireInterval, this.catchUpToNow), new PeriodicSequence.SequenceDefinition[0]));
        }
        PCollection result = seqDef.apply(PeriodicSequence.create());
        if (this.applyWindowing) {
            result = (PCollection)result.apply(Window.into(FixedWindows.of(Duration.millis((long)this.fireInterval.getMillis()))));
        }
        return result;
    }

    private static class RuntimeSequenceFn
    extends DoFn<byte[], PeriodicSequence.SequenceDefinition> {
        @UnknownKeyFor @NonNull @Initialized Duration stopDuration;
        @UnknownKeyFor @NonNull @Initialized Duration fireInterval;
        @UnknownKeyFor @NonNull @Initialized boolean catchUpToNow;

        RuntimeSequenceFn(@UnknownKeyFor @NonNull @Initialized Duration stopDuration, @UnknownKeyFor @NonNull @Initialized Duration fireInterval, @UnknownKeyFor @NonNull @Initialized boolean catchUpToNow) {
            this.stopDuration = stopDuration;
            this.fireInterval = fireInterval;
            this.catchUpToNow = catchUpToNow;
        }

        @DoFn.ProcessElement
        public void process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Instant now = Instant.now();
            c.output(new PeriodicSequence.SequenceDefinition(now, now.plus((ReadableDuration)this.stopDuration), this.fireInterval, this.catchUpToNow));
        }
    }
}

