/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PartitioningWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class FixedWindows
extends PartitioningWindowFn<Object, IntervalWindow> {
    private final @UnknownKeyFor @NonNull @Initialized Duration size;
    private final @UnknownKeyFor @NonNull @Initialized Duration offset;

    public static @UnknownKeyFor @NonNull @Initialized FixedWindows of(@UnknownKeyFor @NonNull @Initialized Duration size) {
        return new FixedWindows(size, Duration.ZERO);
    }

    public @UnknownKeyFor @NonNull @Initialized FixedWindows withOffset(@UnknownKeyFor @NonNull @Initialized Duration offset) {
        return new FixedWindows(this.size, offset);
    }

    private FixedWindows(@UnknownKeyFor @NonNull @Initialized Duration size, @UnknownKeyFor @NonNull @Initialized Duration offset) {
        if (offset.isShorterThan((ReadableDuration)Duration.ZERO) || !offset.isShorterThan((ReadableDuration)size)) {
            throw new IllegalArgumentException("FixedWindows WindowingStrategies must have 0 <= offset < size");
        }
        this.size = size;
        this.offset = offset;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized IntervalWindow assignWindow(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        Instant endOfGlobalWindow;
        Instant start = new Instant(timestamp.getMillis() - timestamp.plus((ReadableDuration)this.size).minus((ReadableDuration)this.offset).getMillis() % this.size.getMillis());
        Instant end = start.isAfter((ReadableInstant)(endOfGlobalWindow = GlobalWindow.INSTANCE.maxTimestamp().plus((ReadableDuration)Duration.millis((long)1L))).minus((ReadableDuration)this.size)) ? endOfGlobalWindow : start.plus((ReadableDuration)this.size);
        return new IntervalWindow(start, end);
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("size", this.size).withLabel("Window Duration")).addIfNotDefault(DisplayData.item("offset", this.offset).withLabel("Window Start Offset"), Duration.ZERO);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
        return this.equals(other);
    }

    @Override
    public void verifyCompatibility(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("Only %s objects with the same size and offset are compatible.", FixedWindows.class.getSimpleName()));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getSize() {
        return this.size;
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getOffset() {
        return this.offset;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (!(object instanceof FixedWindows)) {
            return false;
        }
        FixedWindows other = (FixedWindows)object;
        return this.getOffset().equals((Object)other.getOffset()) && this.getSize().equals((Object)other.getSize());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.size, this.offset);
    }
}

