/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.ParameterizedType;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.ExposedByteArrayInputStream;
import org.apache.beam.sdk.util.ExposedByteArrayOutputStream;
import org.apache.beam.sdk.util.UnownedInputStream;
import org.apache.beam.sdk.util.UnownedOutputStream;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class CoderUtils {
    private static @UnknownKeyFor @NonNull @Initialized ThreadLocal<@UnknownKeyFor @NonNull @Initialized SoftReference<@UnknownKeyFor @NonNull @Initialized ExposedByteArrayOutputStream>> threadLocalOutputStream = new ThreadLocal();
    private static @UnknownKeyFor @NonNull @Initialized ThreadLocal<@UnknownKeyFor @NonNull @Initialized Boolean> threadLocalOutputStreamInUse = ThreadLocal.withInitial(() -> false);

    private CoderUtils() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodeToByteArray(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        return CoderUtils.encodeToByteArray(coder, value, Coder.Context.OUTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodeToByteArray(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        if (threadLocalOutputStreamInUse.get().booleanValue()) {
            ExposedByteArrayOutputStream stream = new ExposedByteArrayOutputStream();
            CoderUtils.encodeToSafeStream(coder, value, stream, context);
            return ((ByteArrayOutputStream)stream).toByteArray();
        }
        threadLocalOutputStreamInUse.set(true);
        try {
            ByteArrayOutputStream stream = CoderUtils.getThreadLocalOutputStream();
            CoderUtils.encodeToSafeStream(coder, value, stream, context);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        finally {
            threadLocalOutputStreamInUse.set(false);
        }
    }

    private static <T> void encodeToSafeStream(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value, @UnknownKeyFor @NonNull @Initialized OutputStream stream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        try {
            coder.encode(value, new UnownedOutputStream(stream), context);
        }
        catch (IOException exn) {
            Throwables.propagateIfPossible(exn, CoderException.class);
            throw new IllegalArgumentException("Forbidden IOException when writing to OutputStream", exn);
        }
    }

    public static <T> T decodeFromByteArray(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedValue) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        return CoderUtils.decodeFromByteArray(coder, encodedValue, Coder.Context.OUTER);
    }

    public static <T> T decodeFromByteArray(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedValue, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        try (ExposedByteArrayInputStream stream = new ExposedByteArrayInputStream(encodedValue);){
            T result = CoderUtils.decodeFromSafeStream(coder, stream, context);
            if (stream.available() != 0) {
                throw new CoderException(stream.available() + " unexpected extra bytes after decoding " + result);
            }
            T t = result;
            return t;
        }
    }

    public static <T> T decodeFromByteString(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized ByteString encodedValue) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return CoderUtils.decodeFromByteString(coder, encodedValue, Coder.Context.OUTER);
    }

    public static <T> T decodeFromByteString(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized ByteString encodedValue, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        InputStream stream = encodedValue.newInput();
        T result = coder.decode(stream, context);
        if (stream.available() != 0) {
            throw new CoderException(stream.available() + " unexpected extra bytes after decoding " + result);
        }
        return result;
    }

    private static <T> T decodeFromSafeStream(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized InputStream stream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        try {
            return coder.decode(new UnownedInputStream(stream), context);
        }
        catch (IOException exn) {
            Throwables.propagateIfPossible(exn, CoderException.class);
            throw new IllegalArgumentException("Forbidden IOException when reading from InputStream", exn);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized ByteArrayOutputStream getThreadLocalOutputStream() {
        ExposedByteArrayOutputStream stream;
        SoftReference<ExposedByteArrayOutputStream> refStream = threadLocalOutputStream.get();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = stream = refStream == null ? null : refStream.get();
        if (stream == null) {
            stream = new ExposedByteArrayOutputStream();
            threadLocalOutputStream.set(new SoftReference<ExposedByteArrayOutputStream>(stream));
        }
        stream.reset();
        return stream;
    }

    public static <T> T clone(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        return CoderUtils.decodeFromByteArray(coder, CoderUtils.encodeToByteArray(coder, value));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized String encodeToBase64(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        byte[] rawValue = CoderUtils.encodeToByteArray(coder, value);
        return BaseEncoding.base64Url().omitPadding().encode(rawValue);
    }

    public static <T> T decodeFromBase64(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized String encodedValue) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        return CoderUtils.decodeFromSafeStream(coder, new ByteArrayInputStream(BaseEncoding.base64Url().omitPadding().decode(encodedValue)), Coder.Context.OUTER);
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor getCodedType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor coderDescriptor) {
        ParameterizedType coderType = (ParameterizedType)coderDescriptor.getSupertype(Coder.class).getType();
        return TypeDescriptor.of(coderType.getActualTypeArguments()[0]);
    }
}

