/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.construction.PCollectionTranslation;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadTranslation {
    private static final @UnknownKeyFor @NonNull @Initialized String JAVA_SERIALIZED_BOUNDED_SOURCE = "beam:java:boundedsource:v1";
    private static final @UnknownKeyFor @NonNull @Initialized String JAVA_SERIALIZED_UNBOUNDED_SOURCE = "beam:java:unboundedsource:v1";

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ReadPayload toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveBoundedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> read) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.Enum.BOUNDED).setSource(ReadTranslation.toProto(read.getSource())).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ReadPayload toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveUnboundedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> read) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.Enum.UNBOUNDED).setSource(ReadTranslation.toProto(read.getSource())).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Source<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> source) {
        if (source instanceof BoundedSource) {
            return ReadTranslation.toProto((BoundedSource)source);
        }
        if (source instanceof UnboundedSource) {
            return ReadTranslation.toProto((UnboundedSource)source);
        }
        throw new IllegalArgumentException(String.format("Unknown %s type %s", Source.class.getSimpleName(), source.getClass()));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> source) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_BOUNDED_SOURCE).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(source))).build();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> boundedSourceFromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ReadPayload payload) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        Preconditions.checkArgument(payload.getIsBounded().equals((Object)RunnerApi.IsBounded.Enum.BOUNDED));
        return (BoundedSource)SerializableUtils.deserializeFromByteArray(payload.getSource().getPayload().toByteArray(), "BoundedSource");
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSourceFromTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ReadTranslation.boundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    public static <T, CheckpointT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointT> unboundedSourceFromTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ReadTranslation.unboundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    private static <T> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ReadPayload getReadPayload(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        return RunnerApi.ReadPayload.parseFrom((ByteString)PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_UNBOUNDED_SOURCE).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(source))).build();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> unboundedSourceFromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ReadPayload payload) {
        Preconditions.checkArgument(payload.getIsBounded().equals((Object)RunnerApi.IsBounded.Enum.UNBOUNDED));
        return (UnboundedSource)SerializableUtils.deserializeFromByteArray(payload.getSource().getPayload().toByteArray(), "UnboundedSource");
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded sourceIsBounded(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        try {
            SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
            return PCollectionTranslation.fromProto(RunnerApi.ReadPayload.parseFrom((ByteString)PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload()).getIsBounded());
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error determining boundedness of Read", e);
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(SplittableParDo.PrimitiveUnboundedRead.class, new UnboundedReadPayloadTranslator()).put(SplittableParDo.PrimitiveBoundedRead.class, (UnboundedReadPayloadTranslator)((Object)new BoundedReadPayloadTranslator())).build();
        }
    }

    public static class BoundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<SplittableParDo.PrimitiveBoundedRead<?>> {
        public static @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator create() {
            return new BoundedReadPayloadTranslator();
        }

        private BoundedReadPayloadTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:read:v1";
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?,  @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveBoundedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto(transform.getTransform());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }

    public static class UnboundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<SplittableParDo.PrimitiveUnboundedRead<?>> {
        public static @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator create() {
            return new UnboundedReadPayloadTranslator();
        }

        private UnboundedReadPayloadTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:read:v1";
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?,  @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveUnboundedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto(transform.getTransform());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }
}

