/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class PCollectionTuple
implements PInput,
POutput {
    final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
    final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pcollectionMap;

    public static @UnknownKeyFor @NonNull @Initialized PCollectionTuple empty(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return new PCollectionTuple(pipeline);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple of(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc) {
        return PCollectionTuple.empty(pc.getPipeline()).and(tag, pc);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple of(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc) {
        return PCollectionTuple.of(new TupleTag(tag), pc);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc2) {
        return PCollectionTuple.of(tag1, pc1).and(tag2, pc2);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc2, @UnknownKeyFor @NonNull @Initialized String tag3, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc3) {
        return PCollectionTuple.of(tag1, pc1, tag2, pc2).and(tag3, pc3);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc2, @UnknownKeyFor @NonNull @Initialized String tag3, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc3, @UnknownKeyFor @NonNull @Initialized String tag4, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc4) {
        return PCollectionTuple.of(tag1, pc1, tag2, pc2, tag3, pc3).and(tag4, pc4);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc2, @UnknownKeyFor @NonNull @Initialized String tag3, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc3, @UnknownKeyFor @NonNull @Initialized String tag4, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc4, @UnknownKeyFor @NonNull @Initialized String tag5, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc5) {
        return PCollectionTuple.of(tag1, pc1, tag2, pc2, tag3, pc3, tag4, pc4).and(tag5, pc5);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple and(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        return new PCollectionTuple(this.pipeline, new ImmutableMap.Builder().putAll(this.pcollectionMap).put(tag, pc).build());
    }

    public <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple and(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized PCollection<T> pc) {
        return this.and(new TupleTag(tag), pc);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized boolean has(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
        return this.pcollectionMap.containsKey(tag);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized boolean has(@UnknownKeyFor @NonNull @Initialized String tag) {
        return this.has(new TupleTag(tag));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> get(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
        PCollection<?> pcollection = this.pcollectionMap.get(tag);
        if (pcollection == null) {
            throw new IllegalArgumentException(String.format("TupleTag %s not found in this PCollectionTuple tuple", tag));
        }
        return pcollection;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> get(@UnknownKeyFor @NonNull @Initialized String tag) {
        return this.get(new TupleTag(tag));
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getAll() {
        return this.pcollectionMap;
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PCollectionTuple, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PCollectionTuple, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionTuple(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this(pipeline, new LinkedHashMap());
    }

    PCollectionTuple(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pcollectionMap) {
        this.pipeline = pipeline;
        this.pcollectionMap = Collections.unmodifiableMap(pcollectionMap);
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized PCollectionTuple ofPrimitiveOutputsInternal(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TupleTagList outputTags, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> coders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded) {
        LinkedHashMap pcollectionMap = new LinkedHashMap();
        for (TupleTag<?> outputTag : outputTags.tupleTags) {
            if (pcollectionMap.containsKey(outputTag)) {
                throw new IllegalArgumentException("TupleTag already present in this tuple");
            }
            PCollection<?> outputCollection = PCollection.createPrimitiveOutputInternal(pipeline, windowingStrategy, isBounded, coders.get(outputTag)).setTypeDescriptor(outputTag.getTypeDescriptor());
            pcollectionMap.put(outputTag, outputCollection);
        }
        return new PCollectionTuple(pipeline, pcollectionMap);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        return ImmutableMap.copyOf(this.pcollectionMap);
    }

    @Override
    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        int i = 0;
        for (Map.Entry<TupleTag<?>, PCollection<?>> entry : this.pcollectionMap.entrySet()) {
            TupleTag<?> tag = entry.getKey();
            PCollection<?> pc = entry.getValue();
            if (pc.getName().equals(PValueBase.defaultName(transformName))) {
                pc.setName(String.format("%s.%s", transformName, tag.getOutName(i)));
            }
            ++i;
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof PCollectionTuple)) {
            return false;
        }
        PCollectionTuple that = (PCollectionTuple)other;
        return this.pipeline.equals(that.pipeline) && this.pcollectionMap.equals(that.pcollectionMap);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.pipeline, this.pcollectionMap);
    }
}

