/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public class ValueWithRecordId<@UnknownKeyFor ValueT> {
    private final ValueT value;
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] id;

    public ValueWithRecordId(ValueT value, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] id) {
        this.value = value;
        this.id = id;
    }

    public ValueT getValue() {
        return this.value;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getId() {
        return this.id;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("value", this.value).toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueWithRecordId)) {
            return false;
        }
        ValueWithRecordId otherRecord = (ValueWithRecordId)other;
        return Objects.deepEquals(this.id, otherRecord.id) && Objects.deepEquals(this.value, otherRecord.value);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(Arrays.hashCode(this.id), this.value);
    }

    public static class StripIdsDoFn<@UnknownKeyFor T>
    extends DoFn<ValueWithRecordId<T>, T> {
        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output(((ValueWithRecordId)c.element()).getValue());
        }
    }

    public static class ValueWithRecordIdCoder<@UnknownKeyFor ValueT>
    extends StructuredCoder<ValueWithRecordId<ValueT>> {
        @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder;
        @UnknownKeyFor @NonNull @Initialized ByteArrayCoder idCoder;

        public static <ValueT> @UnknownKeyFor @NonNull @Initialized ValueWithRecordIdCoder<ValueT> of(@UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
            return new ValueWithRecordIdCoder<ValueT>(valueCoder);
        }

        protected ValueWithRecordIdCoder(@UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
            this.valueCoder = valueCoder;
            this.idCoder = ByteArrayCoder.of();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<ValueT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<ValueT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.valueCoder.encode(((ValueWithRecordId)value).value, outStream);
            this.idCoder.encode(((ValueWithRecordId)value).id, outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ValueWithRecordId<ValueT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ValueWithRecordId<ValueT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new ValueWithRecordId<ValueT>(this.valueCoder.decode(inStream), this.idCoder.decode(inStream, context));
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<ValueT> getValueCoder() {
            return this.valueCoder;
        }
    }
}

