/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataStreamException;

class DBReplyServerAttributes {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] data_;
    private int offset_;
    private int length_;

    public DBReplyServerAttributes(byte[] data, int offset, int length) throws DBDataStreamException {
        this.data_ = data;
        this.offset_ = offset;
        this.length_ = length;
    }

    public final int getCommitmentControlLevelPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 14);
    }

    public final int getDateFormatPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_);
    }

    public final int getDateSeparatorPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 2);
    }

    public final int getDecimalSeparatorPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 8);
    }

    public final String getDefaultSQLLibraryName(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 78, 10);
    }

    public final String getDefaultSQLSchemaName(ConvTable converter) throws DBDataStreamException {
        short schemaLen = BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 114);
        return converter.byteArrayToString(this.data_, this.offset_ + 116, schemaLen);
    }

    public final int getDRDAPackageSize() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 16);
    }

    public final int getIgnoreDecimalDataErrorPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 12);
    }

    public final String getLanguageFeatureCode(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 46, 4);
    }

    public final int getVRM() {
        int v = 0xF & this.data_[this.offset_ + 51];
        int r = 0xF & this.data_[this.offset_ + 53];
        int m = 0xF & this.data_[this.offset_ + 55];
        return (v << 16) + (r << 8) + m;
    }

    public final int getNamingConvetionPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 10);
    }

    public final String getRelationalDBName(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 60, 18);
    }

    public final int getServerCCSID() throws DBDataStreamException {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 19);
    }

    public final String getServerFunctionalLevel(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 50, 10);
    }

    public final String getServerJobIdentifier(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 88, 26);
    }

    public final String getServerLanguageId(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 23, 3);
    }

    public final String getServerLanguageTable(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 26, 10);
    }

    public final String getServerLanguageTableLibrary(ConvTable converter) {
        return converter.byteArrayToString(this.data_, this.offset_ + 36, 10);
    }

    public final int getServerNLSSValue() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 21);
    }

    public final int getTimeFormatPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 4);
    }

    public final int getTimeSeparatorPO() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 6);
    }

    public final int getTranslationIndicator() {
        return this.data_[this.offset_ + 18];
    }
}

