/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLParameter
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6620025554753779980L;
    private String name_;
    private String value_;

    public HTMLParameter() {
    }

    public HTMLParameter(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLParameter was here -->";
    }

    @Override
    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting HTML parameter name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.value_ == null) {
            Trace.log(2, "Attempting to get tag before setting HTML parameter value.");
            throw new ExtendedIllegalStateException("value", 4);
        }
        StringBuffer s = new StringBuffer("<param");
        s.append(" name=\"");
        s.append(this.getName());
        s.append("\"");
        s.append(" value=\"");
        s.append(this.getValue());
        s.append("\"");
        s.append(this.getAttributeString());
        s.append(">");
        s.append("\n");
        return s.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        String old = this.name_;
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.length() == 0) {
            throw new ExtendedIllegalArgumentException("value", 1);
        }
        String old = this.value_;
        this.value_ = value;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", old, value);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

