/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.spanner.v1.PartialResultSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@VisibleForTesting
class GrpcStreamIterator
extends AbstractIterator<PartialResultSet>
implements AbstractResultSet.CloseableIterator<PartialResultSet> {
    private static final Logger logger = Logger.getLogger(GrpcStreamIterator.class.getName());
    private static final PartialResultSet END_OF_STREAM = PartialResultSet.newBuilder().build();
    private final ConsumerImpl consumer = new ConsumerImpl();
    private final BlockingQueue<PartialResultSet> stream;
    private final Statement statement;
    private SpannerRpc.StreamingCall call;
    private volatile boolean withBeginTransaction;
    private TimeUnit streamWaitTimeoutUnit;
    private long streamWaitTimeoutValue;
    private SpannerException error;

    @VisibleForTesting
    GrpcStreamIterator(int prefetchChunks) {
        this(null, prefetchChunks);
    }

    @VisibleForTesting
    GrpcStreamIterator(Statement statement, int prefetchChunks) {
        this.statement = statement;
        this.stream = new LinkedBlockingQueue<PartialResultSet>(prefetchChunks + 1);
    }

    protected final SpannerRpc.ResultStreamConsumer consumer() {
        return this.consumer;
    }

    public void setCall(SpannerRpc.StreamingCall call, boolean withBeginTransaction) {
        Duration streamWaitTimeout;
        this.call = call;
        this.withBeginTransaction = withBeginTransaction;
        ApiCallContext callContext = call.getCallContext();
        Duration duration = streamWaitTimeout = callContext == null ? null : callContext.getStreamWaitTimeout();
        if (streamWaitTimeout != null) {
            if (streamWaitTimeout.getSeconds() > 0L) {
                this.streamWaitTimeoutValue = streamWaitTimeout.getSeconds();
                this.streamWaitTimeoutUnit = TimeUnit.SECONDS;
            } else if (streamWaitTimeout.getNano() > 0) {
                this.streamWaitTimeoutValue = streamWaitTimeout.getNano();
                this.streamWaitTimeoutUnit = TimeUnit.NANOSECONDS;
            }
        }
    }

    @Override
    public void close(@Nullable String message) {
        if (this.call != null) {
            this.call.cancel(message);
        }
    }

    @Override
    public boolean isWithBeginTransaction() {
        return this.withBeginTransaction;
    }

    protected final PartialResultSet computeNext() {
        PartialResultSet next;
        try {
            if (this.streamWaitTimeoutUnit != null) {
                next = this.stream.poll(this.streamWaitTimeoutValue, this.streamWaitTimeoutUnit);
                if (next == null) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "stream wait timeout");
                }
            } else {
                next = this.stream.take();
            }
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
        if (next != END_OF_STREAM) {
            this.call.request(1);
            return next;
        }
        this.call = null;
        if (this.error != null) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)this.error));
        }
        this.endOfData();
        return null;
    }

    private void addToStream(PartialResultSet results) {
        Uninterruptibles.putUninterruptibly(this.stream, (Object)results);
    }

    private class ConsumerImpl
    implements SpannerRpc.ResultStreamConsumer {
        private ConsumerImpl() {
        }

        @Override
        public void onPartialResultSet(PartialResultSet results) {
            GrpcStreamIterator.this.addToStream(results);
        }

        @Override
        public void onCompleted() {
            GrpcStreamIterator.this.addToStream(END_OF_STREAM);
        }

        @Override
        public void onError(SpannerException e) {
            if (GrpcStreamIterator.this.statement != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    e = SpannerExceptionFactory.newSpannerExceptionPreformatted(e.getErrorCode(), String.format("%s - Statement: '%s'", e.getMessage(), GrpcStreamIterator.this.statement.toString()), (Throwable)((Object)e));
                    logger.log(Level.FINEST, "Error executing statement", (Throwable)((Object)e));
                } else {
                    e = SpannerExceptionFactory.newSpannerExceptionPreformatted(e.getErrorCode(), String.format("%s - Statement: '%s'", e.getMessage(), GrpcStreamIterator.this.statement.getSql()), (Throwable)((Object)e));
                }
            }
            GrpcStreamIterator.this.error = e;
            GrpcStreamIterator.this.addToStream(END_OF_STREAM);
        }
    }
}

