/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.OpenCensusScope;
import com.google.cloud.spanner.OpenCensusSpan;
import com.google.cloud.spanner.OpenTelemetryScope;
import com.google.cloud.spanner.OpenTelemetrySpan;
import com.google.cloud.spanner.SpannerOptions;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Tracer;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;

class TraceWrapper {
    private final Tracer openCensusTracer;
    private final io.opentelemetry.api.trace.Tracer openTelemetryTracer;

    TraceWrapper(Tracer openCensusTracer, io.opentelemetry.api.trace.Tracer openTelemetryTracer) {
        this.openTelemetryTracer = openTelemetryTracer;
        this.openCensusTracer = openCensusTracer;
    }

    ISpan spanBuilder(String spanName) {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            return new OpenTelemetrySpan(this.openTelemetryTracer.spanBuilder(spanName).startSpan());
        }
        return new OpenCensusSpan(this.openCensusTracer.spanBuilder(spanName).startSpan());
    }

    ISpan spanBuilderWithExplicitParent(String spanName, ISpan parentSpan) {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            OpenTelemetrySpan otParentSpan = (OpenTelemetrySpan)parentSpan;
            Span otSpan = otParentSpan != null && otParentSpan.getOpenTelemetrySpan() != null ? this.openTelemetryTracer.spanBuilder(spanName).setParent(Context.current().with((ImplicitContextKeyed)otParentSpan.getOpenTelemetrySpan())).startSpan() : this.openTelemetryTracer.spanBuilder(spanName).startSpan();
            return new OpenTelemetrySpan(otSpan);
        }
        OpenCensusSpan parentOcSpan = (OpenCensusSpan)parentSpan;
        io.opencensus.trace.Span ocSpan = this.openCensusTracer.spanBuilderWithExplicitParent(spanName, parentOcSpan != null ? parentOcSpan.getOpenCensusSpan() : null).startSpan();
        return new OpenCensusSpan(ocSpan);
    }

    ISpan getCurrentSpan() {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            return new OpenTelemetrySpan(Span.fromContext((Context)Context.current()));
        }
        return new OpenCensusSpan(this.openCensusTracer.getCurrentSpan());
    }

    ISpan getBlankSpan() {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            return new OpenTelemetrySpan(Span.getInvalid());
        }
        return new OpenCensusSpan((io.opencensus.trace.Span)BlankSpan.INSTANCE);
    }

    IScope withSpan(ISpan span) {
        if (SpannerOptions.getActiveTracingFramework().equals((Object)SpannerOptions.TracingFramework.OPEN_TELEMETRY)) {
            OpenTelemetrySpan openTelemetrySpan = !(span instanceof OpenTelemetrySpan) ? new OpenTelemetrySpan(null) : (OpenTelemetrySpan)span;
            return new OpenTelemetryScope(openTelemetrySpan.getOpenTelemetrySpan().makeCurrent());
        }
        OpenCensusSpan openCensusSpan = !(span instanceof OpenCensusSpan) ? new OpenCensusSpan(null) : (OpenCensusSpan)span;
        return new OpenCensusScope(this.openCensusTracer.withSpan(openCensusSpan.getOpenCensusSpan()));
    }
}

