/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.insertupdate;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.utils.RowMetaUtils;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdate;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateData;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateKeyField;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateLookupField;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateValue;

@Transform(id="InsertUpdate", image="insertupdate.svg", name="i18n::InsertUpdate.Name", description="i18n::InsertUpdate.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::InsertUpdateMeta.keyword"}, documentationUrl="/pipeline/transforms/insertupdate.html")
public class InsertUpdateMeta
extends BaseTransformMeta<InsertUpdate, InsertUpdateData> {
    private static final Class<?> PKG = InsertUpdateMeta.class;
    @HopMetadataProperty(key="lookup")
    private InsertUpdateLookupField insertUpdateLookupField = new InsertUpdateLookupField();
    @HopMetadataProperty(key="commit", injectionKeyDescription="InsertUpdateMeta.Injection.COMMIT_SIZE", injectionKey="COMMIT_SIZE")
    private String commitSize;
    @HopMetadataProperty(key="update_bypassed", injectionKeyDescription="InsertUpdateMeta.Injection.DO_NOT", injectionKey="DO_NOT")
    private boolean updateBypassed;
    @HopMetadataProperty(key="connection", injectionKeyDescription="InsertUpdateMeta.Injection.CONNECTIONNAME", injectionKey="CONNECTIONNAME")
    private String connection;

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public DatabaseMeta getDatabaseMeta() {
        return null;
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public int getCommitSizeVar(IVariables vs) {
        this.commitSize = this.commitSize == null ? "0" : this.commitSize;
        return Integer.parseInt(vs.resolve(this.commitSize));
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public Object clone() {
        InsertUpdateMeta retval = (InsertUpdateMeta)((Object)super.clone());
        return retval;
    }

    public String getTableName() {
        return this.insertUpdateLookupField.getTableName();
    }

    public String getSchemaName() {
        return this.insertUpdateLookupField.getSchemaName();
    }

    public void setDefault() {
        this.commitSize = "100";
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        Database db = null;
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (databaseMeta != null) {
                boolean errorFound;
                boolean first;
                db = new Database(loggingObject, variables, databaseMeta);
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.insertUpdateLookupField.getTableName())) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    IRowMeta r = db.getTableFieldsMeta(variables.resolve(this.insertUpdateLookupField.getSchemaName()), variables.resolve(this.insertUpdateLookupField.getTableName()));
                    if (r != null) {
                        IValueMeta v;
                        int i;
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        for (i = 0; i < this.insertUpdateLookupField.getLookupKeys().size(); ++i) {
                            InsertUpdateKeyField insertUpdateKeyField = this.insertUpdateLookupField.getLookupKeys().get(i);
                            v = r.searchValueMeta(insertUpdateKeyField.getKeyLookup());
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + insertUpdateKeyField.getKeyLookup() + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllLookupFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        for (i = 0; i < this.insertUpdateLookupField.getValueFields().size(); ++i) {
                            InsertUpdateValue insertUpdateValue = this.insertUpdateLookupField.getValueFields().get(i);
                            v = r.searchValueMeta(insertUpdateValue.getUpdateLookup());
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsToUpdateInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + insertUpdateValue.getUpdateLookup() + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    IValueMeta v;
                    int i;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (i = 0; i < this.insertUpdateLookupField.getLookupKeys().size(); ++i) {
                        InsertUpdateKeyField insertUpdateKeyField = this.insertUpdateLookupField.getLookupKeys().get(i);
                        v = prev.searchValueMeta(insertUpdateKeyField.getKeyStream());
                        if (v == null) {
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + insertUpdateKeyField.getKeyStream() + Const.CR;
                        }
                        if (Utils.isEmpty((CharSequence)insertUpdateKeyField.getKeyStream2()) || (v = prev.searchValueMeta(insertUpdateKeyField.getKeyStream2())) != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + insertUpdateKeyField.getKeyStream2() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    for (i = 0; i < this.insertUpdateLookupField.getValueFields().size(); ++i) {
                        InsertUpdateValue insertUpdateValue = this.insertUpdateLookupField.getValueFields().get(i);
                        v = prev.searchValueMeta(insertUpdateValue.getUpdateStream());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingInputStreamFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + insertUpdateValue.getUpdateStream() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsFoundInInput2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
        }
        catch (HopException e) {
            errorMessage = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        finally {
            db.disconnect();
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement sqlStatement;
        block22: {
            DatabaseMeta databaseMeta;
            sqlStatement = new SqlStatement(transformMeta.getName(), null, null);
            String connectionName = variables.resolve(this.connection);
            if (StringUtils.isEmpty((CharSequence)connectionName)) {
                sqlStatement.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NoConnectionDefined", (String[])new String[0]));
                return sqlStatement;
            }
            try {
                databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(connectionName);
                if (databaseMeta == null) {
                    sqlStatement.setError("Error finding database connection " + connectionName + " in the metadata");
                    return sqlStatement;
                }
            }
            catch (Exception e) {
                sqlStatement.setError("Error loading database connection " + connectionName + " from Hop metadata: " + Const.getSimpleStackTrace((Throwable)e));
                return sqlStatement;
            }
            if (prev != null && prev.size() > 0) {
                int i;
                String[] keyLookup = null;
                String[] keyStream = null;
                String[] updateLookup = null;
                String[] updateStream = null;
                if (this.insertUpdateLookupField.getLookupKeys().size() > 0) {
                    keyLookup = new String[this.insertUpdateLookupField.getLookupKeys().size()];
                    for (i = 0; i < this.insertUpdateLookupField.getLookupKeys().size(); ++i) {
                        keyLookup[i] = this.insertUpdateLookupField.getLookupKeys().get(i).getKeyLookup();
                    }
                }
                if (this.insertUpdateLookupField.getLookupKeys().size() > 0) {
                    keyStream = new String[this.insertUpdateLookupField.getLookupKeys().size()];
                    for (i = 0; i < this.insertUpdateLookupField.getLookupKeys().size(); ++i) {
                        keyStream[i] = this.insertUpdateLookupField.getLookupKeys().get(i).getKeyStream();
                    }
                }
                if (this.insertUpdateLookupField.getValueFields().size() > 0) {
                    updateLookup = new String[this.insertUpdateLookupField.getValueFields().size()];
                    for (i = 0; i < this.insertUpdateLookupField.getValueFields().size(); ++i) {
                        updateLookup[i] = this.insertUpdateLookupField.getValueFields().get(i).getUpdateLookup();
                    }
                }
                if (this.insertUpdateLookupField.getValueFields().size() > 0) {
                    updateStream = new String[this.insertUpdateLookupField.getValueFields().size()];
                    for (i = 0; i < this.insertUpdateLookupField.getValueFields().size(); ++i) {
                        updateStream[i] = this.insertUpdateLookupField.getValueFields().get(i).getUpdateStream();
                    }
                }
                IRowMeta tableFields = RowMetaUtils.getRowMetaForUpdate((IRowMeta)prev, (String[])keyLookup, (String[])keyStream, (String[])updateLookup, (String[])updateStream);
                if (!Utils.isEmpty((CharSequence)this.insertUpdateLookupField.getTableName())) {
                    Database db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        String sql;
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, variables.resolve(this.insertUpdateLookupField.getSchemaName()), variables.resolve(this.insertUpdateLookupField.getTableName()));
                        String crTable = db.getDDL(schemaTable, tableFields, null, false, null, true);
                        String crIndex = "";
                        String[] idxFields = null;
                        if (keyLookup != null && keyLookup.length > 0) {
                            idxFields = new String[keyLookup.length];
                            System.arraycopy(keyLookup, 0, idxFields, 0, keyLookup.length);
                        } else {
                            sqlStatement.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingKeyFields", (String[])new String[0]));
                        }
                        if (idxFields != null && !db.checkIndexExists(variables.resolve(this.insertUpdateLookupField.getSchemaName()), variables.resolve(this.insertUpdateLookupField.getTableName()), idxFields)) {
                            String indexName = "idx_" + variables.resolve(this.insertUpdateLookupField.getTableName()) + "_lookup";
                            crIndex = db.getCreateIndexStatement(schemaTable, indexName, idxFields, false, false, false, true);
                        }
                        if ((sql = crTable + Const.CR + crIndex).length() == 0) {
                            sqlStatement.setSql(null);
                            break block22;
                        }
                        sqlStatement.setSql(sql);
                    }
                    catch (HopException e) {
                        sqlStatement.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                    }
                } else {
                    sqlStatement.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                }
            } else {
                sqlStatement.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
            }
        }
        return sqlStatement;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (prev != null) {
                DatabaseImpact ii;
                IValueMeta v;
                int i;
                for (i = 0; i < this.insertUpdateLookupField.getLookupKeys().size(); ++i) {
                    InsertUpdateKeyField keyField = this.insertUpdateLookupField.getLookupKeys().get(i);
                    v = prev.searchValueMeta(keyField.getKeyStream());
                    ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), variables.resolve(this.insertUpdateLookupField.getTableName()), keyField.getKeyLookup(), keyField.getKeyStream(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.insertUpdateLookupField.getValueFields().size(); ++i) {
                    InsertUpdateValue valueField = this.insertUpdateLookupField.getValueFields().get(i);
                    v = prev.searchValueMeta(valueField.getUpdateStream());
                    ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), variables.resolve(this.insertUpdateLookupField.getTableName()), valueField.getUpdateLookup(), valueField.getUpdateStream(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    public boolean isUpdateBypassed() {
        return this.updateBypassed;
    }

    public void setUpdateBypassed(boolean updateBypassed) {
        this.updateBypassed = updateBypassed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realSchemaName = variables.resolve(this.insertUpdateLookupField.getSchemaName());
        String realTableName = variables.resolve(this.insertUpdateLookupField.getTableName());
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        try (Database db = new Database(loggingObject, variables, databaseMeta);){
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.TableNotSpecified", (String[])new String[0]));
            if (!db.checkTableExists(realSchemaName, realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.TableNotFound", (String[])new String[0]));
            IRowMeta iRowMeta = db.getTableFieldsMeta(realSchemaName, realTableName);
            return iRowMeta;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public InsertUpdateLookupField getInsertUpdateLookupField() {
        return this.insertUpdateLookupField;
    }

    public void setInsertUpdateLookupField(InsertUpdateLookupField insertUpdateLookupField) {
        this.insertUpdateLookupField = insertUpdateLookupField;
    }
}

