/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.hop.vfs.azure.AzureFileName;

public class AzureFileNameParser
extends HostFileNameParser {
    private static final AzureFileNameParser instance = new AzureFileNameParser();

    public static AzureFileNameParser getInstance() {
        return instance;
    }

    public AzureFileNameParser() {
        super(443);
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder sb = new StringBuilder(uri);
        UriParser.normalisePath((StringBuilder)sb);
        String normalizedUri = sb.toString();
        String scheme = normalizedUri.substring(0, normalizedUri.indexOf(58));
        Object absPath = "/";
        FileType fileType = FileType.IMAGINARY;
        String[] s = normalizedUri.split("/");
        if (s.length > 1) {
            if (scheme.equals("azure")) {
                String container = s[1];
                for (int i = 1; i < s.length; ++i) {
                    absPath = (String)absPath + s[i];
                    if (s.length <= 1 || i == s.length - 1) continue;
                    absPath = (String)absPath + "/";
                }
                if (uri.endsWith("/")) {
                    fileType = FileType.FOLDER;
                } else if (!((String)absPath).endsWith("/")) {
                    fileType = FileType.FILE;
                }
            } else if (scheme.equals("azfs")) {
                String account = s[1];
                String container = s[2];
                for (int i = 2; i < s.length; ++i) {
                    absPath = (String)absPath + s[i];
                    if (s.length <= 1 || i == s.length - 1) continue;
                    absPath = (String)absPath + "/";
                }
                if (uri.endsWith("/")) {
                    fileType = FileType.FOLDER;
                } else if (!((String)absPath).endsWith("/")) {
                    fileType = FileType.FILE;
                }
            }
        }
        return new AzureFileName(scheme, (String)absPath, fileType);
    }
}

