/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.hop.vfs.azure.AppendBlobInputStream;
import org.apache.hop.vfs.azure.AzureFileName;
import org.apache.hop.vfs.azure.AzureFileSystem;

public class AzureFileObject
extends AbstractFileObject<AzureFileSystem> {
    private final CloudBlobClient service;
    private boolean attached = false;
    private long size;
    private long lastModified;
    private FileType type;
    private List<String> children = null;
    private CloudBlobContainer container;
    private String containerPath;
    private CloudBlob cloudBlob;
    private CloudBlobDirectory cloudDir;
    private String markerFileName = ".cvfs.temp";

    public AzureFileObject(AbstractFileName fileName, AzureFileSystem fileSystem, CloudBlobClient service) throws FileSystemException {
        super(fileName, (AbstractFileSystem)fileSystem);
        this.service = service;
    }

    protected void doSetAttribute(String attrName, Object value) throws Exception {
        if (this.container != null && !this.containerPath.equals("")) {
            if (this.cloudBlob != null) {
                if (attrName.equals("cacheControl")) {
                    this.cloudBlob.getProperties().setCacheControl(value.toString());
                } else if (attrName.equals("contentType")) {
                    this.cloudBlob.getProperties().setContentType(value.toString());
                } else if (attrName.equals("contentMD5")) {
                    this.cloudBlob.getProperties().setContentMD5(value.toString());
                } else if (attrName.equals("contentLanguage")) {
                    this.cloudBlob.getProperties().setContentLanguage(value.toString());
                } else if (attrName.equals("contentDisposition")) {
                    this.cloudBlob.getProperties().setContentDisposition(value.toString());
                } else if (attrName.equals("contentEncoding")) {
                    this.cloudBlob.getProperties().setContentEncoding(value.toString());
                } else {
                    this.cloudBlob.getMetadata().put(attrName, value.toString());
                }
            }
        } else {
            throw new FileSystemException("Setting of attributes not supported on this file.");
        }
    }

    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (this.container != null && !this.containerPath.equals("") && this.cloudBlob != null) {
            attrs.put("cacheControl", this.cloudBlob.getProperties().getCacheControl());
            attrs.put("blobType", this.cloudBlob.getProperties().getBlobType());
            attrs.put("contentDisposition", this.cloudBlob.getProperties().getContentDisposition());
            attrs.put("contentEncoding", this.cloudBlob.getProperties().getContentEncoding());
            attrs.put("contentLanguage", this.cloudBlob.getProperties().getContentLanguage());
            attrs.put("contentType", this.cloudBlob.getProperties().getContentType());
            attrs.put("copyState", this.cloudBlob.getProperties().getCopyState());
            attrs.put("etag", this.cloudBlob.getProperties().getEtag());
            attrs.put("leaseDuration", this.cloudBlob.getProperties().getLeaseDuration());
            attrs.put("leaseState", this.cloudBlob.getProperties().getLeaseState());
            attrs.put("leaseStatus", this.cloudBlob.getProperties().getLeaseStatus());
            attrs.put("pageBlobSequenceNumber", this.cloudBlob.getProperties().getPageBlobSequenceNumber());
            attrs.putAll(this.cloudBlob.getMetadata());
        }
        return attrs;
    }

    protected void doRemoveAttribute(String attrName) throws Exception {
        if (this.container != null && !this.containerPath.equals("") && this.cloudBlob != null) {
            if (Arrays.asList("cacheControl", "blobType", "contentDisposition", "contentEncoding", "contentLanguage", "contentType", "copyState", "etag", "leaseDuration", "leaseState", "leaseStatus", "pageBlobSequenceNumber").contains(attrName)) {
                throw new FileSystemException("Removal of this attributes not supported on this file.");
            }
        } else {
            throw new FileSystemException("Removal of attributes not supported on this file.");
        }
        this.cloudBlob.getMetadata().remove(attrName);
    }

    protected void doAttach() throws URISyntaxException, StorageException {
        if (!this.attached) {
            if (this.getName().getPath().equals("/")) {
                this.children = new ArrayList<String>();
                for (CloudBlobContainer container : this.service.listContainers()) {
                    this.children.add(container.getName());
                }
                this.size = this.children.size();
                this.lastModified = 0L;
                this.type = FileType.FOLDER;
                this.container = null;
                this.containerPath = "";
            } else {
                String containerName = ((AzureFileName)this.getName()).getContainer();
                this.container = this.service.getContainerReference(containerName);
                this.containerPath = ((AzureFileName)this.getName()).getPathAfterContainer();
                String thisPath = "/" + containerName + this.containerPath;
                if (this.container.exists()) {
                    this.children = new ArrayList<String>();
                    if (this.containerPath.equals("")) {
                        if (this.container.exists()) {
                            for (ListBlobItem item : this.container.listBlobs()) {
                                StringBuilder path = new StringBuilder(item.getUri().getPath());
                                UriParser.extractFirstElement((StringBuilder)path);
                                this.children.add(path.toString().substring(1));
                            }
                            this.type = FileType.FOLDER;
                        } else {
                            this.type = FileType.IMAGINARY;
                        }
                        this.lastModified = 0L;
                        this.size = this.children.size();
                    } else {
                        this.cloudBlob = null;
                        this.cloudDir = null;
                        String relpath = AzureFileObject.removeLeadingSlash(((AzureFileName)this.getName().getParent()).getPathAfterContainer());
                        for (ListBlobItem item : relpath.equals("") ? this.container.listBlobs() : this.container.listBlobs(relpath + "/")) {
                            String itemPath = AzureFileObject.removeTrailingSlash(item.getUri().getPath());
                            if (!this.pathsMatch(itemPath, thisPath)) continue;
                            if (item instanceof CloudBlob) {
                                this.cloudBlob = (CloudBlob)item;
                                break;
                            }
                            this.cloudDir = (CloudBlobDirectory)item;
                            for (ListBlobItem blob : this.cloudDir.listBlobs()) {
                                URI blobUri = blob.getUri();
                                String path = blobUri.getPath();
                                while (path.endsWith("/")) {
                                    path = path.substring(0, path.length() - 1);
                                }
                                int idx = path.lastIndexOf(47);
                                if (idx != -1) {
                                    path = path.substring(idx + 1);
                                }
                                this.children.add(path);
                            }
                        }
                        if (this.cloudBlob != null) {
                            Date lastModified2;
                            String disp;
                            this.type = FileType.FILE;
                            this.size = this.cloudBlob.getProperties().getLength();
                            if (this.cloudBlob.getMetadata().containsKey("ActualLength")) {
                                this.size = Long.parseLong((String)this.cloudBlob.getMetadata().get("ActualLength"));
                            }
                            if ((disp = this.cloudBlob.getProperties().getContentDisposition()) != null && disp.startsWith("vfs ; length=\"")) {
                                this.size = Long.parseLong(disp.substring(14, disp.length() - 1));
                            }
                            this.lastModified = (lastModified2 = this.cloudBlob.getProperties().getLastModified()) == null ? 0L : lastModified2.getTime();
                        } else if (this.cloudDir != null) {
                            this.type = FileType.FOLDER;
                            this.size = this.children.size();
                            this.lastModified = 0L;
                        } else {
                            this.lastModified = 0L;
                            this.type = FileType.IMAGINARY;
                            this.size = 0L;
                        }
                    }
                } else {
                    this.lastModified = 0L;
                    this.type = FileType.IMAGINARY;
                    this.size = 0L;
                    this.cloudBlob = null;
                    this.cloudDir = null;
                }
            }
        }
    }

    private boolean pathsMatch(String path, String currentPath) {
        return path.replace("/" + ((AzureFileSystem)this.getFileSystem()).getAccount(), "").equals(currentPath);
    }

    protected void doDetach() throws Exception {
        if (this.attached) {
            this.attached = false;
            this.children = null;
            this.size = 0L;
            this.type = null;
            this.container = null;
            this.containerPath = null;
            this.cloudBlob = null;
            this.cloudDir = null;
        }
    }

    protected void onChange() throws IOException {
        this.refresh();
    }

    protected boolean doIsHidden() throws Exception {
        return this.getName().getBaseName().equals(this.markerFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        if (this.container == null) {
            throw new UnsupportedOperationException();
        }
        FileObject parent = this.getParent();
        boolean lastFile = ((AzureFileObject)parent).doListChildren().length == 1;
        try {
            if (this.containerPath.equals("")) {
                this.container.delete();
            } else {
                if (this.cloudBlob != null) {
                    this.cloudBlob.delete();
                } else if (this.cloudDir != null) {
                    for (ListBlobItem item : this.container.listBlobs(((AzureFileName)this.getName()).getPathAfterContainer(), true)) {
                        String path = item.getUri().getPath();
                        if (!(item instanceof CloudBlob) || !path.startsWith(this.getName().getPath())) continue;
                        ((CloudBlob)item).delete();
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                if (lastFile) {
                    FileObject marker = parent.resolveFile(this.markerFileName);
                    marker.createFile();
                }
            }
        }
        finally {
            this.type = FileType.IMAGINARY;
            this.children = null;
            this.size = 0L;
            this.lastModified = 0L;
        }
    }

    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        return true;
    }

    protected void doRename(FileObject newfile) throws Exception {
        if (this.cloudBlob == null) {
            throw new FileSystemException("Renaming of directories not supported on this file.");
        }
        CloudBlobContainer newContainer = this.service.getContainerReference(((AzureFileName)newfile.getName()).getContainer());
        CloudBlob newBlob = newContainer.getBlobReferenceFromServer(((AzureFileName)newfile.getName()).getPathAfterContainer().substring(1));
        newBlob.startCopy(this.cloudBlob.getUri());
        this.doDelete();
    }

    protected void doCreateFolder() throws StorageException, URISyntaxException, IOException {
        if (this.container == null) {
            throw new UnsupportedOperationException();
        }
        if (this.containerPath.equals("")) {
            this.container.create();
            this.type = FileType.FOLDER;
            this.children = new ArrayList<String>();
        } else {
            CloudBlockBlob blob = this.container.getBlockBlobReference(this.containerPath.substring(1) + "/" + this.markerFileName);
            byte[] buf = "This is a temporary blob created by a Commons VFS application to simulate a folder. It may be safely deleted, but this will hide the folder in the application if it is empty.".getBytes("UTF-8");
            blob.uploadFromByteArray(buf, 0, buf.length);
            this.type = FileType.FOLDER;
            this.children = new ArrayList<String>();
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.lastModified;
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (this.container != null && !this.containerPath.equals("")) {
            if (bAppend) {
                throw new UnsupportedOperationException();
            }
            CloudAppendBlob cab = this.container.getAppendBlobReference(AzureFileObject.removeLeadingSlash(this.containerPath));
            if (this.type == FileType.IMAGINARY) {
                this.type = FileType.FILE;
                return new AppendBlobOutputStream(cab, (OutputStream)cab.openWriteNew());
            }
            return new AppendBlobOutputStream(cab, (OutputStream)cab.openWriteExisting());
        }
        throw new UnsupportedOperationException();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (this.container != null && !this.containerPath.equals("") && this.type == FileType.FILE) {
            return new AppendBlobInputStream(this.cloudBlob.openInputStream(), this.size);
        }
        throw new UnsupportedOperationException();
    }

    protected FileType doGetType() throws Exception {
        return this.type;
    }

    protected String[] doListChildren() throws Exception {
        return this.children == null ? null : this.children.toArray(new String[0]);
    }

    protected long doGetContentSize() throws Exception {
        return this.size;
    }

    private void closeBlob() {
        String pathAfterContainer = AzureFileObject.removeLeadingSlash(((AzureFileName)this.getName().getParent()).getPathAfterContainer()) + "/";
        for (ListBlobItem item : this.container.listBlobs(pathAfterContainer)) {
            String itemPath = item.getUri().getPath();
            if (!(itemPath = AzureFileObject.removeTrailingSlash(itemPath)).equals(this.getName().getPath()) || !(item instanceof CloudBlob)) continue;
            this.cloudBlob = (CloudBlob)item;
        }
    }

    private static String removeTrailingSlash(String itemPath) {
        while (itemPath.endsWith("/")) {
            itemPath = itemPath.substring(0, itemPath.length() - 1);
        }
        return itemPath;
    }

    private static String removeLeadingSlash(String relpath) {
        while (relpath.startsWith("/")) {
            relpath = relpath.substring(1);
        }
        return relpath;
    }

    public class AppendBlobOutputStream
    extends OutputStream {
        private CloudAppendBlob ab;
        private final OutputStream outputStream;
        long written = 0L;

        public AppendBlobOutputStream(CloudAppendBlob ab, OutputStream outputStream) {
            this.ab = ab;
            this.outputStream = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
            this.written(1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        protected void written(int len) {
            this.written += (long)len;
            AzureFileObject.this.lastModified = System.currentTimeMillis();
            AzureFileObject.this.size = this.written;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
            this.written(len);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void close() throws IOException {
            HashMap<String, String> md = new HashMap<String, String>(this.ab.getMetadata());
            md.put("ActualLength", String.valueOf(this.written));
            this.ab.getProperties().setContentDisposition("vfs ; length=\"" + this.written + "\"");
            this.ab.setMetadata(md);
            try {
                this.ab.uploadProperties();
            }
            catch (StorageException e) {
                throw new IOException("Failed to update meta-data.", e);
            }
            this.outputStream.close();
            AzureFileObject.this.closeBlob();
        }
    }
}

