/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HadoopFileSystemOptions
extends PipelineOptions {
    @Description(value="A list of Hadoop configurations used to configure zero or more Hadoop filesystems. By default, Hadoop configuration is loaded from 'core-site.xml' and 'hdfs-site.xml' based upon the HADOOP_CONF_DIR and YARN_CONF_DIR environment variables. To specify configuration on the command-line, represent the value as a JSON list of JSON maps, where each map represents the entire configuration for a single Hadoop filesystem. For example --hdfsConfiguration='[{\"fs.default.name\": \"hdfs://localhost:9998\", ...},{\"fs.default.name\": \"s3a://\", ...},...]'")
    @Default.InstanceFactory(value=ConfigurationLocator.class)
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Configuration> getHdfsConfiguration();

    public void setHdfsConfiguration(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Configuration> var1);

    public static class ConfigurationLocator
    implements DefaultValueFactory<List<Configuration>> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ConfigurationLocator.class);

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Configuration> create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            List<Configuration> configurationList = this.readConfigurationFromHadoopYarnConfigDirs();
            return configurationList.size() > 0 ? configurationList : null;
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Configuration> readConfigurationFromHadoopYarnConfigDirs() {
            ArrayList configurationList = Lists.newArrayList();
            HashSet confDirs = Sets.newHashSet();
            for (Object confDir : Lists.newArrayList((Object[])new String[]{"HADOOP_CONF_DIR", "YARN_CONF_DIR"})) {
                String hadoopConfDir;
                if (!this.getEnvironment().containsKey(confDir) || Strings.isNullOrEmpty((String)(hadoopConfDir = this.getEnvironment().get(confDir)))) continue;
                confDirs.add(hadoopConfDir);
            }
            HashSet explodedConfDirs = Sets.newHashSet();
            for (String confDir : confDirs) {
                Iterable paths = Splitter.on((char)':').split((CharSequence)confDir);
                for (String p : paths) {
                    explodedConfDirs.add(p);
                }
            }
            HashSet confPaths = Sets.newHashSet();
            for (String confDir : explodedConfDirs) {
                java.nio.file.Path path = Paths.get(confDir, new String[0]).normalize();
                if (!new File(confDir).exists() || confPaths.contains(path)) continue;
                confPaths.add(path);
                Configuration conf = new Configuration(false);
                boolean confLoaded = false;
                for (String confName : Lists.newArrayList((Object[])new String[]{"core-site.xml", "hdfs-site.xml"})) {
                    File confFile = new File(confDir, confName);
                    if (!confFile.exists()) continue;
                    LOG.debug("Adding {} to hadoop configuration", (Object)confFile.getAbsolutePath());
                    conf.addResource(new Path(confFile.getAbsolutePath()));
                    confLoaded = true;
                }
                if (!confLoaded) continue;
                configurationList.add(conf);
            }
            return configurationList;
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getEnvironment() {
            return System.getenv();
        }
    }
}

