/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Mailbox;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Inbox<RowT>
extends AbstractNode<RowT>
implements Mailbox<RowT>,
SingleNode<RowT> {
    private final ExchangeService exchange;
    private final MailboxRegistry registry;
    private final long exchangeId;
    private final long srcFragmentId;
    private final Map<String, Buffer> perNodeBuffers;
    private volatile Collection<String> srcNodeIds;
    private Comparator<RowT> comp;
    private List<Buffer> buffers;
    private int requested;
    private boolean inLoop;
    private static final Batch<?> WAITING = new Batch(0, false, null);
    private static final Batch<?> END = new Batch(0, false, null);

    public Inbox(ExecutionContext<RowT> ctx, ExchangeService exchange, MailboxRegistry registry, long exchangeId, long srcFragmentId) {
        super(ctx, ctx.getTypeFactory().createUnknownType());
        this.exchange = exchange;
        this.registry = registry;
        this.srcFragmentId = srcFragmentId;
        this.exchangeId = exchangeId;
        this.perNodeBuffers = new HashMap<String, Buffer>();
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    public void init(ExecutionContext<RowT> ctx, RelDataType rowType, Collection<String> srcNodeIds, @Nullable Comparator<RowT> comp) {
        assert (srcNodeIds != null) : "Collection srcNodeIds not found for exchangeId: " + this.exchangeId;
        assert (this.context().fragmentId() == ctx.fragmentId()) : "different fragments unsupported: previous=" + this.context().fragmentId() + " current=" + ctx.fragmentId();
        this.context(ctx);
        this.rowType(rowType);
        this.comp = comp;
        this.srcNodeIds = new HashSet<String>(srcNodeIds);
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (this.srcNodeIds != null);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::doPush, this::onError);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        this.registry.unregister(this);
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    public void onBatchReceived(String srcNodeId, int batchId, boolean last, List<RowT> rows) throws Exception {
        Buffer buf = this.getOrCreateBuffer(srcNodeId);
        boolean waitingBefore = buf.check() == State.WAITING;
        buf.offer(batchId, last, rows);
        if (this.requested > 0 && waitingBefore && buf.check() != State.WAITING) {
            this.push();
        }
    }

    private void doPush() throws Exception {
        this.checkState();
        this.push();
    }

    private void push() throws Exception {
        if (this.buffers == null) {
            for (String node : this.srcNodeIds) {
                this.checkNode(node);
            }
            this.buffers = this.srcNodeIds.stream().map(this::getOrCreateBuffer).collect(Collectors.toList());
            assert (this.buffers.size() == this.perNodeBuffers.size());
        }
        if (this.comp != null) {
            this.pushOrdered();
        } else {
            this.pushUnordered();
        }
    }

    private boolean checkAllBuffsReady(Iterator<Buffer> it) {
        block5: while (it.hasNext()) {
            Buffer buf = it.next();
            State state = buf.check();
            switch (state) {
                case READY: {
                    continue block5;
                }
                case END: {
                    it.remove();
                    continue block5;
                }
                case WAITING: {
                    return false;
                }
            }
            throw Util.unexpected((Enum)state);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushOrdered() throws Exception {
        if (!this.checkAllBuffsReady(this.buffers.iterator())) {
            return;
        }
        PriorityQueue heap = new PriorityQueue(Math.max(this.buffers.size(), 1), Map.Entry.comparingByKey(this.comp));
        for (Buffer buf : this.buffers) {
            State state = buf.check();
            if (state != State.READY) throw new AssertionError((Object)("Unexpected buffer state: " + state));
            heap.offer(Pair.of(buf.peek(), (Object)buf));
        }
        this.inLoop = true;
        try {
            block10: while (this.requested > 0 && !heap.isEmpty()) {
                this.checkState();
                Buffer buf = (Buffer)((Pair)heap.poll()).right;
                --this.requested;
                this.downstream().push(buf.remove());
                State state = buf.check();
                switch (state) {
                    case END: {
                        this.buffers.remove(buf);
                        continue block10;
                    }
                    case READY: {
                        heap.offer(Pair.of(buf.peek(), (Object)buf));
                        continue block10;
                    }
                    case WAITING: {
                        return;
                    }
                }
                throw Util.unexpected((Enum)state);
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested <= 0) return;
        if (!heap.isEmpty()) return;
        assert (this.buffers.isEmpty());
        this.requested = 0;
        this.downstream().end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushUnordered() throws Exception {
        int idx = 0;
        int noProgress = 0;
        this.inLoop = true;
        try {
            while (this.requested > 0 && !this.buffers.isEmpty()) {
                this.checkState();
                Buffer buf = this.buffers.get(idx);
                switch (buf.check()) {
                    case END: {
                        this.buffers.remove(idx--);
                        break;
                    }
                    case READY: {
                        noProgress = 0;
                        --this.requested;
                        this.downstream().push(buf.remove());
                        break;
                    }
                    case WAITING: {
                        if (++noProgress < this.buffers.size()) break;
                        return;
                    }
                }
                if (++idx != this.buffers.size()) continue;
                idx = 0;
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0 && this.buffers.isEmpty()) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    private void acknowledge(String nodeId, int batchId) throws IgniteInternalCheckedException {
        this.exchange.acknowledge(nodeId, this.queryId(), this.srcFragmentId, this.exchangeId, batchId);
    }

    private Buffer getOrCreateBuffer(String nodeId) {
        return this.perNodeBuffers.computeIfAbsent(nodeId, this::createBuffer);
    }

    private Buffer createBuffer(String nodeId) {
        return new Buffer(nodeId);
    }

    public void onNodeLeft(String nodeId) {
        if (this.context().originatingNodeId().equals(nodeId) && this.srcNodeIds == null) {
            this.context().execute(this::close, this::onError);
        } else if (this.srcNodeIds != null && this.srcNodeIds.contains(nodeId)) {
            this.context().execute(() -> this.onNodeLeft0(nodeId), this::onError);
        }
    }

    private void onNodeLeft0(String nodeId) throws Exception {
        this.checkState();
        if (this.getOrCreateBuffer(nodeId).check() != State.END) {
            throw new IgniteInternalCheckedException(ErrorGroups.Sql.NODE_LEFT_ERR, "Failed to execute query, node left [nodeId=" + nodeId + "]");
        }
    }

    private void checkNode(String nodeId) throws IgniteInternalCheckedException {
        if (!this.exchange.alive(nodeId)) {
            throw new IgniteInternalCheckedException(ErrorGroups.Sql.NODE_LEFT_ERR, "Failed to execute query, node left [nodeId=" + nodeId + "]");
        }
    }

    private final class Buffer {
        private final String nodeId;
        private int lastEnqueued = -1;
        private final PriorityQueue<Batch<RowT>> batches = new PriorityQueue(4);
        private Batch<RowT> curr = this.waitingMark();

        private Buffer(String nodeId) {
            this.nodeId = nodeId;
        }

        private void offer(int id, boolean last, List<RowT> rows) {
            this.batches.offer(new Batch(id, last, rows));
        }

        private Batch<RowT> pollBatch() {
            if (this.batches.isEmpty() || this.batches.peek().batchId != this.lastEnqueued + 1) {
                return this.waitingMark();
            }
            Batch batch = this.batches.poll();
            assert (batch != null && batch.batchId == this.lastEnqueued + 1);
            this.lastEnqueued = batch.batchId;
            return batch;
        }

        private State check() {
            if (this.finished()) {
                return State.END;
            }
            if (this.waiting()) {
                return State.WAITING;
            }
            if (this.isEnd()) {
                this.curr = this.finishedMark();
                return State.END;
            }
            return State.READY;
        }

        private RowT peek() {
            assert (this.curr != null);
            assert (this.curr != WAITING);
            assert (this.curr != END);
            assert (!this.isEnd());
            return this.curr.rows.get(this.curr.idx);
        }

        private RowT remove() throws IgniteInternalCheckedException {
            assert (this.curr != null);
            assert (this.curr != WAITING);
            assert (this.curr != END);
            assert (!this.isEnd());
            Object row = this.curr.rows.set(this.curr.idx++, null);
            if (this.curr.idx == this.curr.rows.size()) {
                Inbox.this.acknowledge(this.nodeId, this.curr.batchId);
                if (!this.isEnd()) {
                    this.curr = this.pollBatch();
                }
            }
            return row;
        }

        private boolean finished() {
            return this.curr == END;
        }

        private boolean waiting() {
            return this.curr == WAITING && (this.curr = this.pollBatch()) == WAITING;
        }

        private boolean isEnd() {
            return this.curr.last && this.curr.idx == this.curr.rows.size();
        }

        private Batch<RowT> finishedMark() {
            return END;
        }

        private Batch<RowT> waitingMark() {
            return WAITING;
        }
    }

    private static enum State {
        END,
        READY,
        WAITING;

    }

    private static final class Batch<RowT>
    implements Comparable<Batch<RowT>> {
        private final int batchId;
        private final boolean last;
        private final List<RowT> rows;
        private int idx;

        private Batch(int batchId, boolean last, List<RowT> rows) {
            this.batchId = batchId;
            this.last = last;
            this.rows = rows;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Batch batch = (Batch)o;
            return this.batchId == batch.batchId;
        }

        public int hashCode() {
            return this.batchId;
        }

        @Override
        public int compareTo(@NotNull Batch<RowT> o) {
            return Integer.compare(this.batchId, o.batchId);
        }
    }
}

