/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.IdGenerator;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;

public class Splitter
extends IgniteRelShuttle {
    private final Deque<FragmentProto> stack = new LinkedList<FragmentProto>();
    private FragmentProto curr;

    public List<Fragment> go(IgniteRel root) {
        ArrayList<Fragment> res = new ArrayList<Fragment>();
        this.stack.push(new FragmentProto(IdGenerator.nextId(), root));
        while (!this.stack.isEmpty()) {
            this.curr = this.stack.pop();
            this.curr.root = this.visit(this.curr.root);
            res.add(this.curr.build());
            this.curr = null;
        }
        return res;
    }

    @Override
    public IgniteRel visit(IgniteReceiver rel) {
        throw new AssertionError();
    }

    @Override
    public IgniteRel visit(IgniteExchange rel) {
        long sourceFragmentId;
        RelOptCluster cluster = rel.getCluster();
        long targetFragmentId = this.curr.id;
        long exchangeId = sourceFragmentId = IdGenerator.nextId();
        IgniteReceiver receiver = new IgniteReceiver(cluster, rel.getTraitSet(), rel.getRowType(), exchangeId, sourceFragmentId);
        IgniteSender sender = new IgniteSender(cluster, rel.getTraitSet(), rel.getInput(), exchangeId, targetFragmentId, rel.distribution());
        this.curr.remotes.add(receiver);
        this.stack.push(new FragmentProto(sourceFragmentId, sender));
        return receiver;
    }

    @Override
    public IgniteRel visit(IgniteTrimExchange rel) {
        return ((SourceAwareIgniteRel)this.processNode(rel)).clone(IdGenerator.nextId());
    }

    @Override
    public IgniteRel visit(IgniteIndexScan rel) {
        return rel.clone(IdGenerator.nextId());
    }

    @Override
    public IgniteRel visit(IgniteTableScan rel) {
        return rel.clone(IdGenerator.nextId());
    }

    private static class FragmentProto {
        private final long id;
        private IgniteRel root;
        private final List<IgniteReceiver> remotes = new ArrayList<IgniteReceiver>();

        private FragmentProto(long id, IgniteRel root) {
            this.id = id;
            this.root = root;
        }

        Fragment build() {
            return new Fragment(this.id, this.root, List.copyOf(this.remotes));
        }
    }
}

