/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Nullable;

public class ConfigurationListenerHolder<L> {
    private final List<Container<L>> containers = new CopyOnWriteArrayList<Container<L>>();

    public void addListener(L listener, long notificationNumber) {
        this.containers.add(new Container<L>(listener, notificationNumber + 1L));
    }

    public void removeListener(L listener) {
        this.containers.remove(new Container<L>(listener, -1L){

            public boolean equals(Object obj) {
                return this.listener == ((Container)obj).listener;
            }
        });
    }

    public Iterator<L> listeners(final long notificationNumber) {
        final Iterator<Container<L>> it = this.containers.iterator();
        return new Iterator<L>(){
            @Nullable
            L curr = this.advance();

            @Override
            public boolean hasNext() {
                return this.curr != null;
            }

            @Override
            public L next() {
                Object next = this.curr;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                this.curr = this.advance();
                return next;
            }

            @Nullable
            L advance() {
                while (it.hasNext()) {
                    Container next = (Container)it.next();
                    if (next.notificationNumber > notificationNumber) continue;
                    return next.listener;
                }
                return null;
            }
        };
    }

    void clear() {
        this.containers.clear();
    }

    private static class Container<L> {
        final L listener;
        final long notificationNumber;

        Container(L listener, long storageRevision) {
            this.listener = listener;
            this.notificationNumber = storageRevision;
        }
    }
}

