/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.UUID;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class TransactionInternalCheckedException
extends IgniteInternalCheckedException {
    public TransactionInternalCheckedException(int code) {
        super(UUID.randomUUID(), code);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + "]";
    }

    public TransactionInternalCheckedException(UUID traceId, int code) {
        super(traceId, code);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + "]";
    }

    public TransactionInternalCheckedException(int code, String message) {
        super(code, message);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + "]";
    }

    public TransactionInternalCheckedException(UUID traceId, int code, String message) {
        super(traceId, code, message);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroup.errorGroupByCode((int)code).name() + "]";
    }

    public TransactionInternalCheckedException(int code, Throwable cause) {
        super(code, cause);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroup.errorGroupByCode((int)code).name() + "]";
    }

    public TransactionInternalCheckedException(UUID traceId, int code, Throwable cause) {
        super(traceId, code, cause);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroup.errorGroupByCode((int)code).name() + "]";
    }

    public TransactionInternalCheckedException(int code, String message, Throwable cause) {
        super(code, message, cause);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroup.errorGroupByCode((int)code).name() + "]";
    }

    public TransactionInternalCheckedException(UUID traceId, int code, String message, Throwable cause) {
        super(traceId, code, message, cause);
        assert (ErrorGroup.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.code()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroup.errorGroupByCode((int)code).name() + "]";
    }
}

