/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.NativeTypes;
import org.apache.ignite.internal.tostring.S;

public class TemporalNativeType
extends NativeType {
    public static final int DEFAULT_TIMESTAMP_PRECISION = 6;
    public static final int DEFAULT_TIME_PRECISION = 0;
    public static final int MAX_TIME_PRECISION = 9;
    private final int precision;

    static TemporalNativeType time(int precision) {
        int size = precision > 3 ? 6 : 4;
        return new TemporalNativeType(NativeTypeSpec.TIME, size, precision);
    }

    static TemporalNativeType datetime(int precision) {
        int size = NativeTypes.DATE.sizeInBytes() + (precision > 3 ? 6 : 4);
        return new TemporalNativeType(NativeTypeSpec.DATETIME, size, precision);
    }

    static TemporalNativeType timestamp(int precision) {
        int size = precision == 0 ? 8 : 12;
        return new TemporalNativeType(NativeTypeSpec.TIMESTAMP, size, precision);
    }

    private TemporalNativeType(NativeTypeSpec typeSpec, int size, int precision) {
        super(typeSpec, size);
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException("Unsupported fractional seconds precision: " + precision);
        }
        this.precision = precision;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public boolean mismatch(NativeType type) {
        return super.mismatch(type) || this.precision < ((TemporalNativeType)type).precision;
    }

    @Override
    public String toString() {
        return S.toString((String)TemporalNativeType.class.getSimpleName(), (String)"name", (Object)((Object)this.spec()), (String)"precision", (Object)this.precision);
    }
}

