/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerException;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableRow;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyValueBinaryViewImpl
extends AbstractTableView
implements KeyValueView<Tuple, Tuple> {
    private final TupleMarshallerImpl marsh;

    public KeyValueBinaryViewImpl(InternalTable tbl, SchemaRegistry schemaReg) {
        super(tbl, schemaReg);
        this.marsh = new TupleMarshallerImpl(schemaReg);
    }

    public Tuple get(@Nullable Transaction tx, @NotNull Tuple key) {
        return this.sync(this.getAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        Row keyRow = this.marshal(key, null);
        return this.tbl.get((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(this::unmarshalValue);
    }

    public NullableValue<Tuple> getNullable(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public Tuple getOrDefault(@Nullable Transaction tx, @NotNull Tuple key, Tuple defaultValue) {
        return this.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @NotNull
    public CompletableFuture<Tuple> getOrDefaultAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple defaultValue) {
        Row keyRow = this.marshal(Objects.requireNonNull(key), null);
        return this.tbl.get((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(r -> (Tuple)IgniteUtils.nonNullOrElse((Object)this.unmarshalValue((BinaryRow)r), (Object)defaultValue));
    }

    public Map<Tuple, Tuple> getAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        return this.sync(this.getAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Map<Tuple, Tuple>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        List<BinaryRowEx> keyRows = this.marshalKeys(Objects.requireNonNull(keys));
        return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(this::unmarshalValue);
    }

    public boolean contains(@Nullable Transaction tx, @NotNull Tuple key) {
        return this.get(tx, key) != null;
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        return this.getAsync(tx, key).thenApply(Objects::nonNull);
    }

    public void put(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        this.sync(this.putAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        Row row = this.marshal(key, val);
        return this.tbl.upsert((BinaryRowEx)row, (InternalTransaction)tx);
    }

    public void putAll(@Nullable Transaction tx, @NotNull Map<Tuple, Tuple> pairs) {
        this.sync(this.putAllAsync(tx, pairs));
    }

    @NotNull
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, @NotNull @NotNull Map<@NotNull Tuple, @NotNull Tuple> pairs) {
        Objects.requireNonNull(pairs);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(pairs.size());
        for (Map.Entry<Tuple, Tuple> pair : pairs.entrySet()) {
            Row row = this.marshal(Objects.requireNonNull(pair.getKey()), Objects.requireNonNull(pair.getValue()));
            rows.add((BinaryRowEx)row);
        }
        return this.tbl.upsertAll(rows, (InternalTransaction)tx);
    }

    public Tuple getAndPut(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return this.sync(this.getAndPutAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndPutAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        Row row = this.marshal(key, val);
        return this.tbl.getAndUpsert((BinaryRowEx)row, (InternalTransaction)tx).thenApply(this::unmarshalValue);
    }

    public NullableValue<Tuple> getNullableAndPut(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAndPutAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public boolean putIfAbsent(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return this.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        Row row = this.marshal(key, val);
        return this.tbl.insert((BinaryRowEx)row, (InternalTransaction)tx);
    }

    public boolean remove(@Nullable Transaction tx, @NotNull Tuple key) {
        return this.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return this.sync(this.removeAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        Row row = this.marshal(key, null);
        return this.tbl.delete((BinaryRowEx)row, (InternalTransaction)tx);
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        Row row = this.marshal(key, val);
        return this.tbl.deleteExact((BinaryRowEx)row, (InternalTransaction)tx);
    }

    public Collection<Tuple> removeAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        return this.sync(this.removeAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> removeAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        List<BinaryRowEx> keyRows = this.marshalKeys(Objects.requireNonNull(keys));
        return this.tbl.deleteAll(keyRows, (InternalTransaction)tx).thenApply(this::unmarshalKeys);
    }

    public Tuple getAndRemove(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        return this.sync(this.getAndRemoveAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndRemoveAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.getAndDelete((BinaryRowEx)this.marshal(key, null), (InternalTransaction)tx).thenApply(this::unmarshalValue);
    }

    public NullableValue<Tuple> getNullableAndRemove(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAndRemoveAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return this.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple oldVal, @NotNull Tuple newVal) {
        return this.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        Row row = this.marshal(key, val);
        return this.tbl.replace((BinaryRowEx)row, (InternalTransaction)tx);
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple oldVal, @NotNull Tuple newVal) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(oldVal);
        Objects.requireNonNull(newVal);
        Row oldRow = this.marshal(key, oldVal);
        Row newRow = this.marshal(key, newVal);
        return this.tbl.replace((BinaryRowEx)oldRow, (BinaryRowEx)newRow, (InternalTransaction)tx);
    }

    public Tuple getAndReplace(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return this.sync(this.getAndReplaceAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.getAndReplace((BinaryRowEx)this.marshal(key, val), (InternalTransaction)tx).thenApply(this::unmarshalValue);
    }

    public NullableValue<Tuple> getNullableAndReplace(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAndReplaceAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public <R extends Serializable> R invoke(@Nullable Transaction tx, @NotNull Tuple key, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<R> invokeAsync(@Nullable Transaction tx, @NotNull Tuple key, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <R extends Serializable> Map<Tuple, R> invokeAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keys, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<Map<Tuple, R>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keys, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private Row marshal(@NotNull Tuple key, @Nullable Tuple val) throws IgniteException {
        try {
            return this.marsh.marshal(key, val);
        }
        catch (TupleMarshallerException ex) {
            throw this.convertException((Throwable)((Object)ex));
        }
    }

    private Tuple unmarshalValue(BinaryRow row) {
        if (row == null) {
            return null;
        }
        return TableRow.valueTuple(this.schemaReg.resolve(row));
    }

    private Map<Tuple, Tuple> unmarshalValue(Collection<BinaryRow> rows) {
        HashMap pairs = IgniteUtils.newHashMap((int)rows.size());
        for (Row row : this.schemaReg.resolve(rows)) {
            if (!row.hasValue()) continue;
            pairs.put(TableRow.keyTuple(row), TableRow.valueTuple(row));
        }
        return pairs;
    }

    private List<BinaryRowEx> marshalKeys(Collection<Tuple> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(keys.size());
        for (Tuple keyRec : keys) {
            keyRows.add((BinaryRowEx)this.marshal(Objects.requireNonNull(keyRec), null));
        }
        return keyRows;
    }

    private Collection<Tuple> unmarshalKeys(Collection<BinaryRow> rows) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(rows.size());
        for (Row row : this.schemaReg.resolve(rows)) {
            assert (!row.hasValue());
            tuples.add(TableRow.keyTuple(row));
        }
        return tuples;
    }
}

