/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replication.request;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteScanCloseReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteScanCloseReplicaRequestBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReadWriteScanCloseReplicaRequestImpl
implements ReadWriteScanCloseReplicaRequest {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private ReplicationGroupId groupId;
    private byte[] groupIdByteArray;
    @IgniteToStringInclude
    private final long scanId;
    @IgniteToStringInclude
    private Long term;
    private byte[] termByteArray;
    @IgniteToStringInclude
    private HybridTimestamp timestamp;
    private byte[] timestampByteArray;
    @IgniteToStringInclude
    private final UUID transactionId;

    private ReadWriteScanCloseReplicaRequestImpl(ReplicationGroupId groupId, byte[] groupIdByteArray, long scanId, Long term, byte[] termByteArray, HybridTimestamp timestamp, byte[] timestampByteArray, UUID transactionId) {
        this.groupId = groupId;
        this.groupIdByteArray = groupIdByteArray;
        this.scanId = scanId;
        this.term = term;
        this.termByteArray = termByteArray;
        this.timestamp = timestamp;
        this.timestampByteArray = timestampByteArray;
        this.transactionId = transactionId;
    }

    byte[] groupIdByteArray() {
        return this.groupIdByteArray;
    }

    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    @Override
    public long scanId() {
        return this.scanId;
    }

    byte[] termByteArray() {
        return this.termByteArray;
    }

    @Override
    public Long term() {
        return this.term;
    }

    byte[] timestampByteArray() {
        return this.timestampByteArray;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadWriteScanCloseReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadWriteScanCloseReplicaRequestImpl otherMessage = (ReadWriteScanCloseReplicaRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.term, otherMessage.term) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.scanId == otherMessage.scanId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.scanId, this.groupId, this.term, this.timestamp, this.transactionId);
        return result;
    }

    public static ReadWriteScanCloseReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject groupIdByteArraymo = marshaller.marshal((Object)this.groupId);
        usedDescriptors.addAll((IntCollection)groupIdByteArraymo.usedDescriptorIds());
        this.groupIdByteArray = groupIdByteArraymo.bytes();
        MarshalledObject termByteArraymo = marshaller.marshal((Object)this.term);
        usedDescriptors.addAll((IntCollection)termByteArraymo.usedDescriptorIds());
        this.termByteArray = termByteArraymo.bytes();
        MarshalledObject timestampByteArraymo = marshaller.marshal((Object)this.timestamp);
        usedDescriptors.addAll((IntCollection)timestampByteArraymo.usedDescriptorIds());
        this.timestampByteArray = timestampByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.groupId = (ReplicationGroupId)marshaller.unmarshal(this.groupIdByteArray, descriptorsObj);
        this.groupIdByteArray = null;
        this.term = (Long)marshaller.unmarshal(this.termByteArray, descriptorsObj);
        this.termByteArray = null;
        this.timestamp = (HybridTimestamp)marshaller.unmarshal(this.timestampByteArray, descriptorsObj);
        this.timestampByteArray = null;
    }

    private static class Builder
    implements ReadWriteScanCloseReplicaRequestBuilder {
        private ReplicationGroupId groupId;
        private byte[] groupIdByteArray;
        private long scanId;
        private Long term;
        private byte[] termByteArray;
        private HybridTimestamp timestamp;
        private byte[] timestampByteArray;
        private UUID transactionId;

        private Builder() {
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder groupId(ReplicationGroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder groupIdByteArray(byte[] groupIdByteArray) {
            this.groupIdByteArray = groupIdByteArray;
            return this;
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder scanId(long scanId) {
            this.scanId = scanId;
            return this;
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder term(Long term) {
            this.term = term;
            return this;
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder termByteArray(byte[] termByteArray) {
            this.termByteArray = termByteArray;
            return this;
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder timestampByteArray(byte[] timestampByteArray) {
            this.timestampByteArray = timestampByteArray;
            return this;
        }

        @Override
        public ReadWriteScanCloseReplicaRequestBuilder transactionId(UUID transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReplicationGroupId groupId() {
            return this.groupId;
        }

        @Override
        public byte[] groupIdByteArray() {
            return this.groupIdByteArray;
        }

        @Override
        public long scanId() {
            return this.scanId;
        }

        @Override
        public Long term() {
            return this.term;
        }

        @Override
        public byte[] termByteArray() {
            return this.termByteArray;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] timestampByteArray() {
            return this.timestampByteArray;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public ReadWriteScanCloseReplicaRequest build() {
            return new ReadWriteScanCloseReplicaRequestImpl(this.groupId, this.groupIdByteArray, this.scanId, this.term, this.termByteArray, this.timestamp, this.timestampByteArray, this.transactionId);
        }
    }
}

