/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.FilterCombiner;
import com.google.uzaygezen.core.FilteredIndexRange;
import com.google.uzaygezen.core.RangeListFilter;
import com.google.uzaygezen.core.SelectiveFilter;
import com.google.uzaygezen.core.ranges.Range;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ListConcatCombiner<T extends Comparable<T>, V extends Content<V>, R extends Range<T, V>>
implements FilterCombiner<RangeListFilter<T, V, R>, V, R> {
    private final int threshold;

    public ListConcatCombiner(int threshold) {
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0, (Object)"threshold must be positive");
        this.threshold = threshold;
    }

    public static <T extends Comparable<T>, V extends Content<V>, R extends Range<T, V>> ListConcatCombiner<T, V, R> unbounded() {
        return new ListConcatCombiner<T, V, R>(Integer.MAX_VALUE);
    }

    @Override
    public SelectiveFilter<RangeListFilter<T, V, R>> combine(FilteredIndexRange<RangeListFilter<T, V, R>, R> lower, FilteredIndexRange<RangeListFilter<T, V, R>, R> higher, V gapEstimate) {
        ListConcatCombiner.checkInputFilteredIndexRange(lower);
        ListConcatCombiner.checkInputFilteredIndexRange(higher);
        RangeListFilter<T, V, R> combinedFilter = lower.getFilter().combine(higher.getFilter(), this.threshold, gapEstimate);
        return SelectiveFilter.of(combinedFilter, combinedFilter.isThresholdExceeded() || lower.isPotentialOverSelectivity() || higher.isPotentialOverSelectivity());
    }

    private static <T extends Comparable<T>, V extends Content<V>, R extends Range<T, V>> void checkInputFilteredIndexRange(FilteredIndexRange<RangeListFilter<T, V, R>, R> filteredIndexRange) {
        List<R> filter = filteredIndexRange.getFilter().getRangeList();
        Preconditions.checkArgument((boolean)((Comparable)((Range)filteredIndexRange.getIndexRange()).getStart()).equals(((Range)filter.get(0)).getStart()), (Object)"invalid start");
        Preconditions.checkArgument((boolean)((Comparable)((Range)filteredIndexRange.getIndexRange()).getEnd()).equals(((Range)filter.get(filter.size() - 1)).getEnd()), (Object)"invalid end");
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

