/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.pagememory.persistence.store.LongOperationAsyncExecutor;
import org.apache.ignite.internal.pagememory.persistence.store.PageStore;
import org.jetbrains.annotations.Nullable;

class GroupPageStoresMap<T extends PageStore> {
    private final ConcurrentHashMap<Integer, List<T>> groupPageStores = new ConcurrentHashMap();
    private final LongOperationAsyncExecutor longOperationAsyncExecutor;

    public GroupPageStoresMap(LongOperationAsyncExecutor longOperationAsyncExecutor) {
        this.longOperationAsyncExecutor = longOperationAsyncExecutor;
    }

    @Nullable
    public List<T> put(Integer grpId, List<T> pageStores) {
        return this.longOperationAsyncExecutor.afterAsyncCompletion(() -> this.groupPageStores.put(grpId, pageStores));
    }

    @Nullable
    public List<T> get(Integer grpId) {
        return this.groupPageStores.get(grpId);
    }

    public boolean containsPageStores(Integer grpId) {
        return this.groupPageStores.containsKey(grpId);
    }

    public Collection<List<T>> allPageStores() {
        return this.groupPageStores.values();
    }

    public void clear() {
        this.groupPageStores.clear();
    }

    public int groupCount() {
        return this.groupPageStores.size();
    }
}

