/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli;

import io.micronaut.configuration.picocli.MicronautFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.VersionProvider;
import org.apache.ignite.internal.cli.commands.TopLevelCliCommand;
import org.apache.ignite.internal.cli.commands.TopLevelCliReplCommand;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.config.ConfigDefaultValueProvider;
import org.apache.ignite.internal.cli.config.StateFolderProvider;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.apache.ignite.internal.cli.core.exception.handler.DefaultExceptionHandlers;
import org.apache.ignite.internal.cli.core.exception.handler.PicocliExecutionExceptionHandler;
import org.apache.ignite.internal.cli.core.repl.Repl;
import org.apache.ignite.internal.cli.core.repl.SessionDefaultValueProvider;
import org.apache.ignite.internal.cli.core.repl.executor.ReplExecutorProvider;
import org.apache.ignite.internal.cli.core.repl.prompt.PromptProvider;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

public class Main {
    private static final String[] BANNER = new String[]{"", "  @|red,bold          #|@              ___                         __", "  @|red,bold        ###|@             /   |   ____   ____ _ _____ / /_   ___", "  @|red,bold    #  #####|@           / /| |  / __ \\ / __ `// ___// __ \\ / _ \\", "  @|red,bold  ###  ######|@         / ___ | / /_/ // /_/ // /__ / / / // ___/", "  @|red,bold #####  #######|@      /_/  |_|/ .___/ \\__,_/ \\___//_/ /_/ \\___/", "  @|red,bold #######  ######|@            /_/", "  @|red,bold   ########  ####|@        ____               _  __           @|red,bold _____|@", "  @|red,bold  #  ########  ##|@       /  _/____ _ ____   (_)/ /_ ___     @|red,bold |__  /|@", "  @|red,bold ####  #######  #|@       / / / __ `// __ \\ / // __// _ \\     @|red,bold /_ <|@", "  @|red,bold  #####  #####|@        _/ / / /_/ // / / // // /_ / ___/   @|red,bold ___/ /|@", "  @|red,bold    ####  ##|@         /___/ \\__, //_/ /_//_/ \\__/ \\___/   @|red,bold /____/|@", "  @|red,bold      ##|@                  /____/\n"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Main.initJavaLoggerProps();
        int exitCode = 0;
        try (MicronautFactory micronautFactory = new MicronautFactory();){
            AnsiConsole.systemInstall();
            if (args.length != 0 || !Main.isatty()) {
                try {
                    exitCode = Main.executeCommand(args, micronautFactory);
                }
                catch (Exception e) {
                    System.err.println("Error occurred during command execution");
                }
            } else {
                try {
                    Main.enterRepl(micronautFactory);
                }
                catch (Exception e) {
                    System.err.println("Error occurred during REPL initialization");
                }
            }
        }
        finally {
            AnsiConsole.systemUninstall();
        }
        System.exit(exitCode);
    }

    private static boolean isatty() {
        return System.console() != null;
    }

    private static void enterRepl(MicronautFactory micronautFactory) throws Exception {
        ReplExecutorProvider replExecutorProvider = (ReplExecutorProvider)micronautFactory.create(ReplExecutorProvider.class);
        replExecutorProvider.injectFactory(micronautFactory);
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("zle", "widget");
        aliases.put("bindkey", "keymap");
        SessionDefaultValueProvider defaultValueProvider = (SessionDefaultValueProvider)micronautFactory.create(SessionDefaultValueProvider.class);
        VersionProvider versionProvider = (VersionProvider)micronautFactory.create(VersionProvider.class);
        System.out.println(Main.banner(versionProvider));
        ConnectToClusterQuestion question = (ConnectToClusterQuestion)micronautFactory.create(ConnectToClusterQuestion.class);
        replExecutorProvider.get().execute(Repl.builder().withPromptProvider((PromptProvider)micronautFactory.create(PromptProvider.class)).withAliases(aliases).withCommandClass(TopLevelCliReplCommand.class).withDefaultValueProvider(defaultValueProvider).withCallExecutionPipelineProvider((executor, exceptionHandlers, line) -> CallExecutionPipeline.builder(executor).inputProvider(() -> new StringCallInput(line)).output(System.out).errOutput(System.err).exceptionHandlers(new DefaultExceptionHandlers()).exceptionHandlers(exceptionHandlers).build()).withOnStart(question::askQuestionOnReplStart).withHistoryFileName("history").withTailTipWidgets().build());
    }

    private static int executeCommand(String[] args, MicronautFactory micronautFactory) throws Exception {
        CommandLine cmd = new CommandLine(TopLevelCliCommand.class, (CommandLine.IFactory)micronautFactory);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PicocliExecutionExceptionHandler());
        cmd.setDefaultValueProvider((CommandLine.IDefaultValueProvider)micronautFactory.create(ConfigDefaultValueProvider.class));
        return cmd.execute(args);
    }

    private static String banner(VersionProvider versionProvider) {
        String banner = Arrays.stream(BANNER).map(arg_0 -> ((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO).string(arg_0)).collect(Collectors.joining("\n"));
        return "\n" + banner + "\n" + " ".repeat(22) + versionProvider.getVersion()[0] + "\n\n";
    }

    @Deprecated
    private static void initJavaLoggerProps() {
        InputStream propsFile = Main.class.getResourceAsStream("/cli.java.util.logging.properties");
        if (propsFile != null) {
            try {
                LogManager.getLogManager().updateConfiguration(propsFile, s -> {
                    if (s.equals("java.util.logging.FileHandler.pattern")) {
                        return (o, n) -> {
                            if (n == null) {
                                return o;
                            }
                            try {
                                return Main.getLogsDir() + "/" + n;
                            }
                            catch (IOException e) {
                                return n;
                            }
                        };
                    }
                    return (o, n) -> n == null ? o : n;
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getLogsDir() throws IOException {
        String envLogsDir = System.getenv("IGNITE_CLI_LOGS_DIR");
        String logsDir = envLogsDir != null ? envLogsDir : StateFolderProvider.getStateFile("logs").getAbsolutePath();
        File logsDirFile = new File(logsDir);
        if (!logsDirFile.exists() && !logsDirFile.mkdirs()) {
            throw new IOException("Failed to create directory " + logsDir);
        }
        if (logsDirFile.isDirectory()) {
            return logsDir;
        }
        throw new IOException(logsDir + " is not a directory");
    }
}

