/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster;

import java.util.List;
import org.apache.ignite.internal.cli.commands.cluster.init.ClusterInitOptions;
import org.apache.ignite.internal.cli.core.call.CallInput;

public class ClusterInitCallInput
implements CallInput {
    private final String clusterUrl;
    private final List<String> metaStorageNodes;
    private final List<String> cmgNodes;
    private final String clusterName;

    private ClusterInitCallInput(String clusterUrl, List<String> metaStorageNodes, List<String> cmgNodes, String clusterName) {
        this.clusterUrl = clusterUrl;
        this.metaStorageNodes = metaStorageNodes;
        this.cmgNodes = cmgNodes;
        this.clusterName = clusterName;
    }

    public static ClusterInitCallInputBuilder builder() {
        return new ClusterInitCallInputBuilder();
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public List<String> getMetaStorageNodes() {
        return this.metaStorageNodes;
    }

    public List<String> getCmgNodes() {
        return this.cmgNodes;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public static class ClusterInitCallInputBuilder {
        private String clusterUrl;
        private List<String> metaStorageNodes;
        private List<String> cmgNodes;
        private String clusterName;

        public ClusterInitCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        public ClusterInitCallInputBuilder fromClusterInitOptions(ClusterInitOptions clusterInitOptions) {
            this.metaStorageNodes = clusterInitOptions.getMetaStorageNodes();
            this.cmgNodes = clusterInitOptions.getCmgNodes();
            this.clusterName = clusterInitOptions.getClusterName();
            return this;
        }

        public ClusterInitCallInput build() {
            return new ClusterInitCallInput(this.clusterUrl, this.metaStorageNodes, this.cmgNodes, this.clusterName);
        }
    }
}

