/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleter;

@Singleton
public class DynamicCompleterRegistry {
    private final List<CompletionStrategy> completionStrategiesList = new ArrayList<CompletionStrategy>();

    public List<DynamicCompleter> findCompleters(String[] words) {
        return this.completionStrategiesList.stream().filter(strategy -> strategy.canBeApplied(words)).map(CompletionStrategy::completer).collect(Collectors.toList());
    }

    public void register(Predicate<String[]> predicate, DynamicCompleter completer) {
        this.completionStrategiesList.add(new CompletionStrategy(predicate, completer));
    }

    public void register(String[] prefixWords, DynamicCompleter completer) {
        this.register(words -> this.samePrefix((String[])words, prefixWords), completer);
    }

    private boolean samePrefix(String[] words, String[] prefixWords) {
        if (words.length < prefixWords.length) {
            return false;
        }
        for (int i = 0; i < prefixWords.length; ++i) {
            if (words[i].equals(prefixWords[i])) continue;
            return false;
        }
        return true;
    }

    private static class CompletionStrategy {
        private final Predicate<String[]> predicate;
        private final DynamicCompleter completer;

        private CompletionStrategy(Predicate<String[]> predicate, DynamicCompleter completer) {
            this.predicate = predicate;
            this.completer = completer;
        }

        boolean canBeApplied(String[] words) {
            return this.predicate.test(words);
        }

        DynamicCompleter completer() {
            return this.completer;
        }
    }
}

