/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.executor;

import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.jline.console.SystemRegistry;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;

public class RegistryCommandExecutor
implements Call<StringCallInput, Object> {
    private final SystemRegistry systemRegistry;
    private final Parser parser;

    public RegistryCommandExecutor(SystemRegistry systemRegistry, Parser parser) {
        this.systemRegistry = systemRegistry;
        this.parser = parser;
    }

    @Override
    public CallOutput<Object> execute(StringCallInput input) {
        try {
            Object executionResult = this.systemRegistry.execute(input.getString());
            if (executionResult == null) {
                return DefaultCallOutput.empty();
            }
            return DefaultCallOutput.success(executionResult);
        }
        catch (Exception e) {
            return DefaultCallOutput.failure(e);
        }
    }

    public void cleanUp() {
        this.systemRegistry.cleanUp();
    }

    public boolean hasCommand(String line) {
        ParsedLine pl = this.parser.parse(line, 0, Parser.ParseContext.SPLIT_LINE);
        return !pl.words().isEmpty() && this.systemRegistry.hasCommand(this.parser.getCommand((String)pl.words().get(0)));
    }
}

