/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessageBuilder;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClassDescriptorListMessageImpl
implements ClassDescriptorListMessage {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 9;
    @IgniteToStringInclude
    private final Collection<ClassDescriptorMessage> messages;

    private ClassDescriptorListMessageImpl(Collection<ClassDescriptorMessage> messages) {
        this.messages = messages;
    }

    @Override
    public Collection<ClassDescriptorMessage> messages() {
        return this.messages;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(ClassDescriptorListMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 9;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassDescriptorListMessageImpl otherMessage = (ClassDescriptorListMessageImpl)other;
        return Objects.equals(this.messages, otherMessage.messages);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.messages);
        return result;
    }

    public static ClassDescriptorListMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messages != null) {
            for (ClassDescriptorMessage obj : this.messages) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messages != null) {
            for (ClassDescriptorMessage obj : this.messages) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements ClassDescriptorListMessageBuilder {
        private Collection<ClassDescriptorMessage> messages;

        private Builder() {
        }

        @Override
        public ClassDescriptorListMessageBuilder messages(Collection<ClassDescriptorMessage> messages) {
            this.messages = messages;
            return this;
        }

        @Override
        public Collection<ClassDescriptorMessage> messages() {
            return this.messages;
        }

        @Override
        public ClassDescriptorListMessage build() {
            return new ClassDescriptorListMessageImpl(this.messages);
        }
    }
}

